<?php
include_once dirname(__DIR__).'/Url/URL.php';
include_once dirname(__DIR__).'/Session/SESSION.php';

if (!class_exists("VIEW")){
    class VIEW{

        private $websitePath;
        private $session;
        private $url;

        public function __construct($viewMainPath, $skipUrlIndexCount = 0){
            $this->websitePath = $viewMainPath;
            $this->session = new SESSION();
            $this->url = new URL($skipUrlIndexCount);
        }

        public function __get($name) {
            return $this->show($name);
        }
        
        public function show($name){
            $name  = trim($name);
            
            if ($this->isStartWithNumber($name)) $name = '_'.$name;
            return $this->getPage($this->websitePath.$name.'.php', $name);
        }
        
        private function getPage($path, $class){
	    $v = null;
            if (file_exists($path)){
                $controller = &$this->session->{DATA::controllerString};
                $model = &$this->session->{DATA::modelString};
                $ctrl = &$this->session->{DATA::ctrlString};
                
                $url = &$this->url;
                $session = &$this->session;
                $view = &$this;
                include $path;

                if (class_exists($class)){
                    $v = new $class();
                    $v->controller = $controller;
                    $v->url = $url;
                    $v->model = $model;
                    $v->ctrl = $ctrl;
                    $v->session = $session;
                    $v->view = $view;

                    if (method_exists($v, 'init')){
                        $v->init();
                    }
                }else{
                    $v = "NOT NULL_168";
                }
            }
            return $v;
        }
        
        private function isStartWithNumber($str){
            $a = substr($str, 0, 1);
            $ret = false;
            switch ($a){
                case '1':
                case '2':        
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case '0':
                    $ret = true;
            }
            return $ret;
        }
    }
}
?>