<?php

include_once dirname(__DIR__).'/Url/URL.php';
include_once dirname(__DIR__).'/Controller/CONTROLLER.php';
include_once dirname(__DIR__).'/Controls/CONTROLS.php';
include_once dirname(__DIR__).'/Session/SESSION.php';

if (!class_exists("ROUTE")){
    class ROUTE{
        private $controllerPath;
        private $p = null;
        public $showError;
        public $errorFile;
        public $skipUrlIndexCount;
        /**
         * Compress the output HTML stream
         * @var Boolean  
         */
        public $isCompress = false;

        public function __construct($controllerPath){
            $this->controllerPath = $controllerPath;
            
            $this->errorFile = "../error-log";
            $this->skipUrlIndexCount = 0;
        }
        
        public function error($status){
            $this->showError = $status;
        }

        /**
         * use to set default page for your website in case other page not found.
         * @param String $pageName set default page
         */
        public function defualt($pageName){
            if (file_exists($this->controllerPath.$pageName.'Controller.php'))
                $this->p = $pageName;
        }

        /**
         * run your page
         */
        public function run(){
            $url = new URL($this->skipUrlIndexCount);
            if ($this->showError == false){
                error_reporting(E_ALL ^ E_NOTICE);
                ini_set("display_errors", 0);
            }else{
		      error_reporting(E_ALL);
		      ini_set("display_errors", 1);
	       }
            @header('X-Powered-By: leam_lidara@yahoo.com');
            if ($this->isCompress) $this->isCompress = $this->gCompressHeader();
            
            $session = new SESSION();
            $session->{DATA::ctrlString} = new CONTROLS();
            $session->{DATA::controllerString} = new CONTROLLER(CONTROLLER_);
            $session->{DATA::modelString} = new MODEL(MODEL_);
            $session->{DATA::viewString} = new VIEW(VIEW_, $this->skipUrlIndexCount);
            
            $Controller = new CONTROLLER($this->controllerPath, $this->skipUrlIndexCount);
            $Controller->defaultPage = $this->p;
            
            $obj = $Controller->get(str_replace(".", "_", $url->getPage()));

            //run if page not found
            if ($obj == null) {
                if ($this->p != null) $obj = $Controller->get($this->p);
                else
                    header('location: /');
            }
            
            //get request method
            $method = strtoupper($_SERVER['REQUEST_METHOD']);

            //loading controller with request method
            if (method_exists($obj, $method)){
                $this->invokeMethod($obj, $method, $url);
            }else{
                //Check if Local or hosting
                $isHosting = true;
                $ser = new SERVER();
                $ser = $ser->getIP();
                if ($ser == "127.0.0.1" || $ser = "::1") $isHosting = false;
                
                if ($isHosting === true){
                    if (method_exists($obj, "GET")){
                        $this->invokeMethod($obj, "GET", $url);
                    }else{
                        echo "No method were found!";
                    }
                }else{
                    echo "No method were found!";
                }
                unset($isHosting);
                unset($ser);
            }
            
            if ($this->isCompress) $this->gCompressFooter();
            @ob_flush();
            $this->removeOldLog("error_log");
            if ($this->showError == false){
                $error = error_get_last();
                if ($error !== null){
                    $this->removeOldLog($this->errorFile);
                    file_put_contents($this->errorFile, '['.date("Y-m-d h:i:s A")."] Error: ".$error['type']." ".$error['message']." On file: ".$error['file'].' line '.$error['line'].PHP_EOL, FILE_APPEND);
                }
            }
        }
        
        private function appendHtmlToHead($html){
            $abc = ob_get_contents();
            $result = "";
            $headPattern = "<head>";
            ob_clean();
            echo $abc;
        }
        
        private function invokeMethod($obj, $method, $url){
            $refl = new ReflectionMethod(get_class($obj), $method);
            $numParams = $refl->getNumberOfParameters();

            if ($numParams > 0)
            {
                $param = explode('/', $url->getFullUrl());
                $cnt = count($param);
                if (strpos($param[$cnt-1], "?") > 0){
                    $c = explode("?", $param[$cnt-1]);
                    $param[$cnt-1] = $c[0];
                }
                foreach($_GET as $key=>$val){
                    $param[$key] = $val;
                }
                $obj->$method($param);
            }else{
                $obj->$method();
            }
        }
        
        private function gCompressHeader(){
            if (extension_loaded('zlib')){
                $phpver = phpversion();

                $useragent = (isset($_SERVER["HTTP_USER_AGENT"]) ) ? $_SERVER["HTTP_USER_AGENT"] : (isset($HTTP_USER_AGENT) ? $HTTP_USER_AGENT : "");
                if ($phpver > "4.0"){
                    if ($phpver >= '4.0.4pl1' && (strstr($useragent,'compatible') || strstr($useragent,'Gecko'))){
                        @ob_start('ob_gzhandler');
                    }else if (isset($HTTP_SERVER_VARS)){
                        if(strstr($HTTP_SERVER_VARS['HTTP_ACCEPT_ENCODING'], 'gzip') ) {
                            @ob_start();
                            @ob_implicit_flush(0);
                            @header('Content-Encoding: gzip');
                            return true;
                        }
                    }else if (isset($_SERVER['HTTP_ACCEPT_ENCODING']) && substr_count($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip')){
                        @ob_start("ob_gzhandler");
                    }
                }
            }
            
            return false;
        }
        
        private function gCompressFooter(){
            $gzip_contents = @ob_get_contents();
            @ob_end_clean();

            $gzip_size = strlen($gzip_contents);
            $gzip_crc = crc32($gzip_contents);

            $gzip_contents = gzcompress($gzip_contents, 9);
            $gzip_contents = substr($gzip_contents, 0, strlen($gzip_contents) - 4);

            echo "\x1f\x8b\x08\x00\x00\x00\x00\x00";
            echo $gzip_contents;
            echo pack('V', $gzip_crc);
            echo pack('V', $gzip_size);
        }
        
        private function removeOldLog($filename){
            if (is_file($filename) == false) return;
            $contet = file_get_contents($filename);
            $arr = array();
            preg_match_all("/(?<=\[)\d{2,4}-.{2,3}-\d{2,4}(?=\s\d{2}:\d{2}:\d{2}\s.*?])/u", $contet, $arr);
            if (count($arr) < 1) return;
            $arr = array_unique($arr[0]);
            $date = strtotime(date("Y-m-d") . " - 7day");
            $spliter = "2000-01-01";
            foreach($arr as $a){
                $d = strtotime($a);
                if ($d > $date) continue;
                if ($d > strtotime($spliter)) $spliter = $a;
            }
            if ($spliter == "2000-01-01") return;
            $contet = explode($spliter, $contet);
            $contet = $contet[count($contet) - 1];
            $contet = str_replace(strtok($contet, "\n"), "", $contet);
            @unlink($filename);
            file_put_contents($filename, $contet, FILE_APPEND);
        }
    }
}

?>