<?php header('Content-Type: text/javascript'); ?>
function initTiny(selectorId){
    tinymce.init({
        selector: "textarea#" + selectorId,
        theme: "modern",
        height: 350,
        link_list: [
            {title: 'My page 1', value: 'http://www.tinymce.com'},
            {title: 'My page 2', value: 'http://www.tecrail.com'}
        ],
        plugins: [
             "advlist autolink link image lists charmap print preview hr anchor pagebreak",
             "searchreplace wordcount visualblocks visualchars insertdatetime media nonbreaking spellchecker",
             "table contextmenu directionality emoticons paste textcolor responsivefilemanager colorpicker code"
       ],
        relative_urls: false,
        browser_spellcheck : true ,
        filemanager_title:"Filemanager",
        external_filemanager_path:"/filemanager/",
        external_plugins: { "filemanager" : "/filemanager/plugin.min.js"},
        codemirror: {
        indentOnInit: true, // Whether or not to indent code on init. 
        path: 'CodeMirror'
      },
      setup : function(ed) {
                ed.on('change', function(e) {
                    $("#" + selectorId).val(tinyMCE.get(selectorId).getContent());
                });
       },
       image_advtab: true,// | copy paste
       toolbar1: "undo redo | bold italic underline | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | styleselect",
       toolbar2: "| responsivefilemanager | image | media | link unlink anchor | print preview code | forecolor backcolor"
     });
}