<?php

class systemModel
{
    private $db;
    function init(){
        $this->db = new DATABASE(DB_HOST, DB_NAME, DB_USER, DB_PASS);
    }
    
    function getSetting($settingId = 1){
        $sql = "select * from tbl_setting where sc_id=:id limit 1";
        $a = $this->db->executeQuery($sql, array(":id"=>$settingId), PDO::FETCH_OBJ);
        if (count($a) > 0) return $a[0];
        return NULL;
    }
    
    function doEditSetting($id = 1){
        if (is_numeric($id) == false) return "Invalid Setting Selected!";
        $name = $this->ctrl->name->getText();
        if ($name == "") return "Site Name cannot be empty!";
        $fd = $this->ctrl->fdLength->getText();
        if (is_numeric($fd) == false) return "4D Length must be numeric!";
        if ($fd > 127 || $fd < 1) return "4D Length can only be from 1 to 127!";
        $toto = $this->ctrl->totoLength->getText();
        if (is_numeric($fd) == false) return "4D Length must be numeric!";
        if ($toto > 127 || $toto < 1) return "Toto Length can only be from 1 to 127!";
        
        $mfd = $this->ctrl->mpoolsLength->getText();
        if (is_numeric($mfd) == false) return "Multiple Pools Length must be numeric!";
        if ($mfd > 127 || $mfd < 0) return "Multiple Pools Length can only be from 0 to 127!";
        
        $keyword = $this->ctrl->keyword->getText();
        $desc = $this->ctrl->desc->getText();
        $sql = "update tbl_setting set sc_name=:name, sc_keywords=:keyword, sc_description=:desc, sc_4d_length=:fd, sc_toto_length=:toto, sc_4d_m_length=:mfd where sc_id=:id limit 1";
        $data = array(":name"=>$name, ":keyword"=>$keyword, ":desc"=>$desc, ":fd"=>$fd, ":toto"=>$toto, ":id"=>$id, ":mfd"=>$mfd);
        $a = $this->db->executeUpdate($sql, $data);
        return $a;
    }
    
    function get4DLength($settingId = 1){
        $sql = "select sc_4d_length from tbl_setting where sc_id=:id limit 1";
        return $this->db->executeScalare($sql, array(":id"=>$settingId));
    }
    
    function getTotoLength($settingId = 1){
        $sql = "select sc_toto_length from tbl_setting where sc_id=:id limit 1";
        return $this->db->executeScalare($sql, array(":id"=>$settingId));
    }
}
