<?php

class poolsModel {
    private $db;
            
    function init(){
        $this->db = new DATABASE(DB_HOST, DB_NAME, DB_USER, DB_PASS);
    }
    
    function doAddPools($is_mpools){
        $date = $this->ctrl->date->getText();
        $result = $this->ctrl->result->getText();
        
        if ($result == ""){
            echo "Result cannot be empty!";
            return;
        }
        
        $desc = strip_tags($this->ctrl->desc->getText());
        $price = strip_tags($this->ctrl->price->getDText());
        
        if ($price == "" || $price == NULL){
            echo "Please select a price!";
            return;
        }
        
        if ($is_mpools == "n"){
            $sql = "select drawno from tbl_draw where date_=:date limit 1";
            $r = $this->db->executeScalare($sql, array(":date"=>$date));
            if ($r > 0 && $r !== "" && $r !== NULL){
                $sql = "select count(drawno) from tbl_pools where priceid=:price and drawno=:drawno limit 1";
                $r = $this->db->executeScalare($sql, array(":price"=>$price, ":drawno"=>$r));
                if ($r > 0){
                    echo "Cannot have the same price on the same day, please check again!";
                    return;
                }
            }
        }
        
        $a = DateTime::createFromFormat("Y-m-d", $date);
        $usr = $this->model->login->getUserId();
        $drawno = $this->db->executeScalare("select drawno from tbl_draw where date_=:date limit 1", array(":date"=>$date));
        if ($drawno == "" || $drawno == NULL || $drawno < 1){
            $date_name = $a->format("l");
            $month_name = $a->format("F");
            $sql = "select dayid from tbl_day where lower(dayname)=lower(:name) limit 1";
            $date_name = $this->db->executeScalare($sql, array(":name"=>$date_name));

            $sql = "select monthid from tbl_month where lower(monthname)=lower(:name) limit 1";
            $month_name = $this->db->executeScalare($sql, array(":name"=>$month_name));
            $today = date("Y-m-d H:i:s");
            $sql = "insert into tbl_draw(date_, day_id, month_id, ins_date) values(:now, :day, :month, :insdate)";
            $data = array(":now"=>$date, ":day"=>$date_name, ":month"=>$month_name, ":insdate"=>$today);
            $this->db->executeUpdate($sql, $data);
            $drawno = $this->db->executeScalare("select drawno from tbl_draw where ins_date=:now and date_=:date limit 1", array(":now"=>$today, ":date"=>$date));
            if ($drawno == "" || $drawno == NULL || $drawno < 1){
                echo "0"; return;
            }
        }
        
        if ($drawno !== "" && $drawno !== NULL){
            $sql = "insert into tbl_pools(drawno, result, description,  priceid, is_mpools, usr_id, ins_time) values(:drawno, :result, :desc, :price, upper(:mpools), :usr_id, :time)";
            $data = array(":drawno"=>$drawno, ":result"=>$result, ":price"=>$price, ":desc"=>$desc, ":mpools"=>$is_mpools, ":usr_id"=>$usr, ":time"=>date("H:i:s"));
            $a = $this->db->executeUpdate($sql, $data);
            if ($a > 0) $this->model->login->log("Add new pools [result=$result, price=$price]");
        }
        echo $a;
        //$start = (date('D') != 'Mon') ? date('Y-m-d', strtotime('last Monday')) : date('Y-m-d');
       //$finish = (date('D') != 'Sat') ? date('Y-m-d', strtotime('next Saturday')) : date('Y-m-d');
    }
    
    function getPoolsOfDate($date, $is_multiple = 'n'){
        $sql = "select c.*, d.price from
                                    (select b.* from (
                                            select drawno from tbl_draw where date_=:date 
                                    ) a inner join tbl_pools b on a.drawno=b.drawno
                                    where is_mpools=upper(:m)) c
                            inner join tbl_price d on c.priceid = d.priceid order by d.price";
        $data = array(":date"=>$date, ":m"=>$is_multiple);
        $rows = $this->db->executeQuery($sql, $data, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            foreach($rows as $row){
                $act = "<span class='edit glyphicon glyphicon-pencil point' title='Edit' style='padding-right: 20%;'></span><span class='delete glyphicon glyphicon-trash point' title='Delete'></span>";
                $prim = $this->ctrl->get($row->drawno . "|" . $row->result . "|" . $row->priceid . "|" . $row->is_mpools . "|" . $row->ins_time);
                echo "<tr id='$prim'><td>{$row->result}</td><td>{$row->description}</td><td>{$row->price}</td><td class='al-center'>$act</td></tr>".PHP_EOL;
            }
            echo "<script>
                activeTooltip();
                $('.edit').click(function(){
                    $('#blanket').css('display', 'table');
                    var a = $(this).parent().parent().attr('id');
                    var u = '/ajax.htm/' + a + '?page=addpools&token=" . $this->ctrl->edit . "';
                    $('#" . $this->ctrl->hd . "').val(a);
                    $.ajax({url:u}).done(function(msg){
                        if (msg !== '0'){
                            var b = msg.split('[dara_spliter]');
                            if (b.length > 1){
                                $('#" . $this->ctrl->result . "').val(b[0]);
                                $('#" . $this->ctrl->desc . "').val(b[1]);
                                $('#" . $this->ctrl->price . "').val(b[2]);
                                $('#" . $this->ctrl->date . "').attr('disabled', 'disabled');
                                    
                                $('#" . $this->ctrl->btnOk . "').val('Update');
                                $('#" . $this->ctrl->btnReset . "').val('Cancel');
                                $('#panel-header').html('<b>Edit Pools</b>');
                            }
                        }
                        $('#blanket').css('display', 'none');
                    });
                });
                
                $('.delete').click(function(){
                    $('#myModalLabel').html('Confirmation');
                    $('#modelbody').html('Are you sure you want to delete this item?');
                    $('#btnmclose').html('No');
                    $('#btnmok').show();
                    $('#btnmok').html('Yes');
                    var a = $(this).parent().parent().attr('id');
                    $('#" . $this->ctrl->hd . "').val(a);
                    $('#myModal').modal({show: true});
                });
            </script>";
        }else{
            echo "<tr><td colspan='3' class='al-center'>No pools on this day!</td></tr>";
        }
    }
    
    function getEditPools($poolsEid){
        $eid = explode("|", $this->ctrl->getName($poolsEid));
        if (count($eid) === 5){
            
            $sql = "select * from tbl_pools where drawno=:drawno  and result=:result and priceid=:priceid and is_mpools=:is_mpools and ins_time=:time limit 1";
            $data = array(":drawno"=>$eid[0], ":result"=>$eid[1], ":priceid"=>$eid[2], ":is_mpools"=>$eid[3], ":time"=>$eid[4]);
            
            $rows = $this->db->executeQuery($sql, $data, PDO::FETCH_OBJ);
            if(count($rows) > 0){
                $rows = $rows[0];
                $spliter = "[dara_spliter]";
                echo $rows->result . $spliter . $rows->description . $spliter . $this->ctrl->get($rows->priceid);
                return;
            }
        }
        echo "0";
    }
    
    function doEditPools(){
         $eid = explode("|", $this->ctrl->hd->getDText());
        if (count($eid) > 3){
            $result = strip_tags($this->ctrl->result->getText());

            if ($result == ""){
                echo "Result cannot be empty!";
                return;
            }

            $desc = strip_tags($this->ctrl->desc->getText());
            $price = $this->ctrl->price->getDText();

            if ($price == "" || $price == NULL){
                echo "Please select a price!";
                return;
            }

            $usr = $this->model->login->getUserId();
            $sql = "update tbl_pools set result=:result, description=:desc, priceid=:price, usr_id=:usr, ins_time=:time
                                    where drawno=:drawno and result=:oresult  and priceid=:priceid and is_mpools=:is_mpools limit 1";
            
            $data = array(":result"=>$result, ":price"=>$price, ":desc"=>$desc, ":drawno"=>$eid[0], ":oresult"=>$eid[1], ":priceid"=>$eid[2], ":is_mpools"=>$eid[3], ":usr"=>$usr, ":time"=>date("H:i:s"));
            $a = $this->db->executeUpdate($sql, $data);
            if ($a > 0) $this->model->login->log("Update pools [result=$result, price=$price]");
            echo $a;
            return;
        }
        echo "0";
    }
    
    function doDeletePools($poolsEid){
        $eid = explode("|", $this->ctrl->getName($poolsEid));
        if (count($eid) === 5){
            $sql = "delete from tbl_pools where drawno=:drawno and result=:result and priceid=:priceid and is_mpools=:is_mpools and ins_time=:time limit 1";
            $data = array(":drawno"=>$eid[0], ":result"=>$eid[1], ":priceid"=>$eid[2], ":is_mpools"=>$eid[3], ":time"=>$eid[4]);
            $a = $this->db->executeUpdate($sql, $data, PDO::FETCH_OBJ);
            if ($a > 0) $this->model->login->log("Delete pools [result={$eid[1]}, price={$eid[2]}, drawno={$eid[0]}]");
            echo $a;
            return;
        }
        echo "0";
    }
}

?>