<div class="panel panel-default left">
    <div class="panel-heading" id="panel-header">
        <b>Add New Pools</b>
    </div>
    <div class="panel-body">
        <form method="POST" id="<?php echo $ctrl->form1; ?>" class="form-horizontal">
            <input type="hidden" id="<?php echo $ctrl->hd; ?>" name="<?php echo $ctrl->hd; ?>"/>
            <div class="row form-group">
                <label class="col-sm-4 control-label" for="<?php echo $ctrl->date; ?>">Date <span class="require">*</span></label>
                <div class="col-sm-8">
                    <label class="input-group">
                        <input type="text" class="form-control" id="<?php echo $ctrl->date; ?>" value="<?php echo $this->ed_date; ?>" name="<?php echo $ctrl->date; ?>"/>
                        <span class="input-group-addon point"><span class="glyphicon glyphicon-calendar"></span></span>
                    </label>
                </div>
            </div>
            <div class="row form-group">
                <label class="col-sm-4 control-label" for="<?php echo $ctrl->result; ?>">Result <span class="require">*</span></label>
                <div class="col-sm-8">
                    <div class="input-group">
                        <input type="text" class="form-control" id="<?php echo $ctrl->result; ?>" name="<?php echo $ctrl->result; ?>"/>
                        <span class="input-group-addon point" id="<?php echo $ctrl->random; ?>"><span class="glyphicon glyphicon-random"></span></span>
                    </div>
                </div>
            </div>
            <div class="row form-group">
                <label class="col-sm-4 control-label" for="<?php echo $ctrl->desc; ?>">Description</label>
                <div class="col-sm-8">
                    <input type="text" class="form-control" id="<?php echo $ctrl->desc; ?>" value="Draw" name="<?php echo $ctrl->desc; ?>"/>
                </div>
            </div>
            <div class="row form-group">
                <label class="col-sm-4 control-label" for="<?php echo $ctrl->price; ?>">Price <span class="require">*</span></label>
                <div class="col-sm-8">
                    <select id="<?php echo $ctrl->price; ?>" name="<?php echo $ctrl->price; ?>" class="form-control">
                        <option value=""><b>Select one of these prices</b></option>
                            <?php echo $model->price->getPriceForPools(); ?>
                    </select>
                </div>
            </div>
            <div class="row form-group">
                <span class="col-sm-4"></span>
                <div class="col-sm-8">
                    <div class="pull-right">
                        <span class="require">*</span> required field
                    </div><br/>
                    <input type="button" value="Save" id="<?php echo $ctrl->btnOk; ?>" class="btn btn-default"/>
                    <input type="button" value="Reset" class="btn btn-default" id="<?php echo $ctrl->btnReset; ?>"/>
                </div>
            </div>
        </form>
    </div>
</div>
<div class="panel panel-default right">
    <div class="panel-heading">
        <b id="date_label">Pools of <?php echo $this->ed_date; ?></b>
    </div>
    <div class="panel-body">
        <table class="table">
            <thead>
                <tr>
                    <th class="col-sm-3">Result</th>
                    <th class="col-sm-5">Description</th>
                    <th class="col-sm-4">Price</th>
                    <th class="col-sm-2">Action</th>
                </tr>
            </thead>
            <tbody id="<?php echo $ctrl->body; ?>">
                <?php
                $model->pools->getPoolsOfDate($this->ed_date);
        ?>
            </tbody>
        </table>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function (){
        $("#<?php echo $ctrl->result; ?>").select();
        
        var <?php echo $ctrl->pub_date; ?> = "<?php echo date("Y-m-d") ?>";
        jQuery('#<?php echo $ctrl->date; ?>').datetimepicker({
            timepicker:false,
            format:'Y-m-d'
        });
        
        $("#<?php echo $ctrl->random; ?>").click(function (){
            var c = "";
            for (var i = 0; i < <?php echo $model->system->get4DLength(); ?>; i++){
                var x = Math.floor((Math.random() * 10));
                c += x;
            }
            $("#<?php echo $ctrl->result; ?>").val(c);
        });
        
        $("#<?php echo $ctrl->result; ?>").keypress(function (e){
            var code = e.keyChar || e.keyCode || e.which;
            if ((code > 47 && code < 58) || code === 8 || code === 9){
                $(this).attr("title", "");
                $(this).tooltip("destroy");
                return true;
            }
            $(this).attr("title", "Only numeric are allowed!");
            $(this).tooltip("show");
            return false;
        });
        $("#<?php echo $ctrl->btnReset; ?>").click(reset);
        
        $("#<?php echo $ctrl->btnOk; ?>").click(function (){
            var <?php echo $ctrl->result; ?> = $("#<?php echo $ctrl->result; ?>").val().trim();
            var <?php echo $ctrl->price; ?> = $("#<?php echo $ctrl->price; ?>").val().trim();
            var isError = false;
            if (<?php echo $ctrl->result; ?> === ""){
                $("#<?php echo $ctrl->result; ?>").attr("title", "This field cannot be empty!");
                $("#<?php echo $ctrl->result; ?>").tooltip("show");
                isError = true;
            }
            if (<?php echo $ctrl->price; ?> === ""){
                $("#<?php echo $ctrl->price; ?>").attr("title", "This field cannot be empty!");
                $("#<?php echo $ctrl->price; ?>").tooltip("show");
                isError = true;
            }
            if (isError === true) return;
            
            $("#<?php echo $ctrl->result; ?>").attr("title", "");
            $("#<?php echo $ctrl->result; ?>").tooltip("destroy");
            $("#<?php echo $ctrl->price; ?>").attr("title", "");
            $("#<?php echo $ctrl->price; ?>").tooltip("destroy");
            
            if ($(this).val() === "Save"){
                $("#<?php echo $ctrl->form1; ?>").attr("action", "/process/addpools.aspx?token=<?php echo $ctrl->save; ?>");
            }else{
                $("#<?php echo $ctrl->form1; ?>").attr("action", "/process/addpools.aspx?token=<?php echo $ctrl->edit; ?>");
            }
            
            $("#<?php echo $ctrl->form1; ?>").submit();
        });
        
        $("#<?php echo $ctrl->form1; ?>").submit(function (){
            $("#blanket").css("display", "table");
            $(this).ajaxSubmit({
                success : function (msg){
                    
                    var pos = "</div>";
                    if (msg === "1"){
                        <?php echo $ctrl->pub_date; ?> = "";
                        reset();
                        <?php echo $ctrl->fnQuery; ?>();
                        
                        $('#myModalLabel').html('Success');
                        $('#modelbody').html('Proess Completed!');
                        $('#btnmclose').html('Close');
                        $('#btnmok').hide();
                        $('#myModal').modal({show: true});
                    }else{
                        if (msg === "0"){
                            msg = "There were some problem while we are trying to process your request!";
                        }
                        
                        $('#myModalLabel').html('Error');
                        $('#modelbody').html(msg);
                        $('#btnmclose').html('Close');
                        $('#btnmok').hide();
                        $('#myModal').modal({show: true});
                        
                        $("#blanket").css("display", "none");
                    }
                }
            });
            return false;
        });
        
        $('#<?php echo $ctrl->date; ?>').on("change", <?php echo $ctrl->fnQuery; ?>);
        
        function <?php echo $ctrl->fnQuery; ?>(){
             if (<?php echo $ctrl->pub_date; ?> !== $("#<?php echo $ctrl->date; ?>").val()){
                $("#blanket").css("display", "table");
                <?php echo $ctrl->pub_date; ?> = $("#<?php echo $ctrl->date; ?>").val();
                $("#date_label").html("Result of " + <?php echo $ctrl->pub_date; ?>);
                $.ajax({
                    url: "/ajax.htm/" + $("#<?php echo $ctrl->date; ?>").val() + "/?page=addpools&token=<?php echo $ctrl->get; ?>"
                }).done(function (msg){
                    $("#<?php echo $ctrl->body; ?>").html(msg);
                    $("#blanket").css("display", "none");
                });
            }
        }
        
        $('#myModal').on('hidden.bs.modal', function (e) {
            if (<?php echo $ctrl->pub_date; ?> === "delete"){
                <?php echo $ctrl->pub_date; ?> = "";
                        
                $('#blanket').css('display', 'table');
                var a = $("#<?php echo $ctrl->hd; ?>").val();
                var u = '/process/addpools.aspx?has=' + a + '&token=<?php echo $ctrl->delete; ?>';
                $('#<?php echo $ctrl->hd; ?>').val('');
                $.ajax({
                    url:u,
                    type: 'POST'
                }).done(function(msg){
                    if (msg === '1'){
                        <?php echo $ctrl->fnQuery; ?>();
                        $('#myModalLabel').html('Success');
                        $('#modelbody').html('Process Completed!');
                    }else{
                        $('#myModalLabel').html('Error');
                        $('#modelbody').html('There were something error while we are trying to process your request!');
                    }
                    $('#btnmclose').val('Close');
                    $('#btnmok').hide();
                    $('#myModal').modal({show: true});
                    $("#blanket").css("display", "none");
                });
            }
        });
        $("#btnmok").click(function (){
            <?php echo $ctrl->pub_date; ?> = "delete";
        });
        
        function reset(){
            $("#<?php echo $ctrl->result; ?>").val("");
            $("#<?php echo $ctrl->desc; ?>").val("Draw");
            $("#<?php echo $ctrl->price; ?>").val("");
            $("#panel-header").html("<b>Add New Pools</b>");
            $("#<?php echo $ctrl->btnOk; ?>").val("Save");
            $("#<?php echo $ctrl->btnReset; ?>").val("Reset");
            
            $("#<?php echo $ctrl->result; ?>").attr("title", "");
            $("#<?php echo $ctrl->result; ?>").tooltip("destroy");
            $("#<?php echo $ctrl->price; ?>").attr("title", "");
            $("#<?php echo $ctrl->price; ?>").tooltip("destroy");
            $("#<?php echo $ctrl->date; ?>").removeAttr("disabled");
            
            $("#<?php echo $ctrl->result; ?>").select(); 
        }
    });
</script>