<?php

class uploadModel
{
        
    function uploadImage($ctrlName, $uploadPath, $width = NULL){
        $ctrlName = (string)$ctrlName;
        $allowedExt = array("jpg", "png", "gif", "bmp", "jpeg");
        $uploadPath = _CHILE_HTDOCS_.$uploadPath;
        $img = NULL;
        if (isset($_FILES[$ctrlName])){
            $upd = new UPLOAD($uploadPath, $allowedExt);
            $img = $upd->beginUpload($ctrlName, 52000);
            $p = $uploadPath . $img;
            $ext = "";
            if ($width !== null && file_exists($p) && is_file($p)){
                $uploadedFile = strtolower($img);
                if (strpos($uploadedFile, "png") !== false)
                {
                    $ext = "png";
                    $image = @imagecreatefrompng($p);
                }
                else if (strpos($uploadedFile, "gif") !== false){
                    $ext = "gif";
                    $image = @imagecreatefromgif($p);
                }else{
                    $ext = "jpg";
                    $image = @imagecreatefromjpeg($p);
                }

                $height = $width/2;
                if ($image){
                    $image_width = imagesx($image);
                    $image_height = imagesy($image);

                    // Clip image
                    $ratio = $width / $image_width;
                    $height = $image_height * $ratio;

                    $tmp_img = imagecreatetruecolor($width, $height);
                    imagecopyresampled($tmp_img, $image, 0, 0, 0, 0,
                                                            $width, $height, $image_width, $image_height);
                    imagedestroy($image);
                    $image = $tmp_img;
                }else{
                    $image = imagecreate($width, $height);
                    imagecolorallocate($image,0,0,0);
                }

                if ($ext == "jpg")
                    imagejpeg($image, $p);
                else if ($ext == "gif")
                    imagegif ($image, $p);
                else
                    imagepng ($image, $p);
            }
        }
        return $img;
    }
    
    function createThumb($file, $width = NULL){
        $p = _CHILE_HTDOCS_ .$file;
        $thum = "";
        if ($width !== null && file_exists($p) && is_file($p)){
            $a = pathinfo($p);
            $thum = "thum_" . $a["filename"]. '.' . $a["extension"];
            $path = $a['dirname'];
            $ext = "";
            $uploadedFile = strtolower($a["extension"]);
            if (strpos($uploadedFile, "png") !== false)
            {
                $ext = "png";
                $image = @imagecreatefrompng($p);
            }
            else if (strpos($uploadedFile, "gif") !== false){
                $ext = "gif";
                $image = @imagecreatefromgif($p);
            }else{
                $ext = "jpg";
                $image = @imagecreatefromjpeg($p);
            }
            
            $height = $width/2;
            if ($image){
                $image_width = imagesx($image);
                $image_height = imagesy($image);

                // Clip image
                $ratio = $width / $image_width;
                $height = $image_height * $ratio;

                $tmp_img = imagecreatetruecolor($width, $height);
                imagecopyresampled($tmp_img, $image, 0, 0, 0, 0,
                                                        $width, $height, $image_width, $image_height);
                imagedestroy($image);
                $image = $tmp_img;
            }else{
                $image = imagecreate($width, $height);
                imagecolorallocate($image,0,0,0);
            }
            
            
            if ($ext == "jpg")
                imagejpeg($image, $path . "/" . $thum);
            else if ($ext == "gif")
                imagegif ($image, $path . "/" . $thum);
            else
                imagepng ($image, $path . "/" . $thum);
        }
        return $thum;
    }
    
    function validateDate($date, $format = 'Y-m-d'){
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }
    
    function getCategory($db, $id){
        $sql = "select * from tbl_category where cat_id = :id limit 1";
        $data = array(":id"=>$id);
        $header = $db->executeQuery($sql, $data);
        if (count($header) < 1) return "";
        $header = $header[0]["cat_name"];
        
        $sql = "select * from tbl_category where cat_parent_id = :id";
        $rows = $db->executeQuery($sql, $data);
        echo "<optgroup label='$header'>";
        foreach ($rows as $row){
            $id = $row["cat_id"];
            $eid = $this->ctrl->$id;
            $name = $row["cat_name"];
            echo "<option value='$eid'>$name</option>" . PHP_EOL;
        }
        echo "</optgroup>";
    }
}

?>