<?php

class dashboardModel {
    private $paging;
    private $db;
    function init(){
        $this->paging = new PAGING(DB_HOST, DB_NAME, DB_USER, DB_PASS, 10);
        $this->db = new DATABASE(DB_HOST, DB_NAME, DB_USER, DB_PASS);
    }
    
    function getDashboard1($page = 1){
        if (is_numeric($page) === FALSE || $page < 1) $page = 1;
        
        $result = "";
        $sql = "select c.*, d.price from (
                                    select a.*, b.date_ from tbl_pools a inner join tbl_draw b on a.drawno=b.drawno order by date_ desc
                            ) c inner join tbl_price d on c.priceid = d.priceid order by c.priceid asc";
        
        $rows = $this->paging->executeQuery("select drawno, date_ from tbl_draw order by date_ desc", array(), $page, PDO::FETCH_OBJ);

        $rows = $this->paging->executeQuery($sql, array(), $page, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            $da = array();
            $mda = array();
            $mindex = array();
            foreach($rows as $row){
                $date = str_replace("-", "", (string)$row->date_);
                if ($row->is_mpools == "N"){
                    if (isset($da["$date"]) == FALSE) $da["$date"] = array();
                    $da["$date"][$row->priceid] = array();
                    $da["$date"][$row->priceid][0] = $row->price;
                    $da["$date"][$row->priceid][1] = $row->description;
                    $da["$date"][$row->priceid][2] = $row->result;
                    $da["$date"][$row->priceid][3] = $row->date_;
                }else{
                    if (isset($mda["$date"]) == FALSE){ 
                        $mda["$date"] = array();
                        $mindex["$date"] = array();
                    }
                    if (isset($mindex["$date"]["$row->price"]) === FALSE){
                        $mindex["$date"]["$row->price"] = 0;
                        $mda["$date"]["$row->price"] = array();
                    }
                    if (isset($da["$date"]) == FALSE) $da["$date"] = array();
                    $da["$date"][$row->priceid] = array();
                    $da["$date"][$row->priceid][3] = $row->date_;
                    //$mda["$date"][0 + $mindex["$date"]] = $row->price;
                    $mda["$date"]["$row->price"][0 + $mindex["$date"]["$row->price"]] = $row->result;
                    $mindex["$date"]["$row->price"] += 1;
                }
            }
            $da = $this->sortArray($da);
            //$mda = $this->sortArray($mda);
            $cnt = 1;
            foreach($da as $key=>$val){
                $isEven = ($cnt % 2 == 1 ? TRUE : FALSE);
                $pull = ($isEven ? "left" : "right");
                $result .= ($isEven ? "<div class='overflow'>" : "" );
                $date = end($val);
                $date = $date[3];
                //$date = $date[3];
                $result .= "<div class='panel panel-default $pull'>
                                                <div class='panel-heading'>
                                                    <b class='pro-date point' title='Click me to edit these results'>$date</b>
                                                    <b class='label label-default pull-right point' title='Click me to edit these results'>Edit</b>
                                                </div>
                                                <div class='panel-body clr-height'>";

                if (count($val) > 1){
                    $abc = 0;
                    $bca = "";
                    foreach($val as $k=>$v){
                        if (count($v) > 1){
                             $bca .= "<tr><td>{$v[0]}</td><td>{$v[1]}</td><td>{$v[2]}</td></tr>";
                             $abc++;
                        }
                    }
                    if ($abc > 0) $result .= "<table class='table'>
                                                            <thead><tr><th>Price</th><th>Description</th><th>Result</th></tr></thead><tbody>" . $bca . "</tbody></table>";
                    else $result .= "$bca";
                }
                //Generate Multi pools
                if (array_key_exists($key, $mda)){
                    //print_r($mda);echo "<br/>";
                    $val = $mda[$key];
                    $i = 0;

                    foreach($val as $key1=>$val1){
                        $result .= "<table class='table center'><thead><tr><th colspan=2 class='al-center'>{$key1}</th></tr></thead><tbody>";

                        foreach($val1 as $key2=>$val2){
                            if ($i == 0) $result .= "<tr>";
                            $result .= "<td>$val2</td>";

                            $i++;
                            if ($i == 2){
                                $i = 0;
                                $result .= "</tr>";
                            }
                        }
                        $result .= "</tbody></table>";
                    }
                }

                $result .="</div>
                                            </div>";
                $result .= ($isEven ? "" : "</div>");
                $cnt++;
            }
            $result .= ($cnt % 2 == 1 ? "" : "</div>");

            $a = $this->paging->getPagingControl("/dashboard.aspx", $page);
            if ($a !== ""){
                $result .= "<div class='pull-right al-right' style='width:50%; display:inline-flex; justify-content:flex-end; margin-bottom:10px; padding-right: 15px;'>" . $a . "</div>";
            }
        }
        return $result;
    }
    
    function getDashboard($pageNumber = 1){
        //$pageNumber = $this->url->getSubPage(1);
        $sql = "select drawno, date_ from tbl_draw order by drawno desc";
        $data = array(":now"=>date("Y-m-d H:i:s"));
        return $this->getResultBySQL($sql, $data, $pageNumber);
    }
    
    function getResultBySQL($sql, $data, $pageNumber=1){
        $drawnos = $this->paging->executeQuery($sql, $data, $pageNumber, PDO::FETCH_OBJ);
        $result = "";
        if (count($drawnos) > 0){
            $sSql = "";
            foreach($drawnos as $r){
                $sSql .= "drawno='$r->drawno' or ";
            }
            $sSql = substr($sSql, 0, strlen($sSql) - strlen(" or "));
            $sql = "select a.*, b.price from (
                                    select drawno, result, description, priceid, is_mpools from tbl_pools where $sSql 
                               ) a inner join tbl_price b on a.priceid=b.priceid order by priceid, result asc, drawno desc";
//echo $sql . "<br/><br/>";
            $pools = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
            $sql = "select drawno, result1, result2, result3, result4, result5, result6, additional 
                                from tbl_toto where $sSql order by drawno desc";
//            echo $sql . "<br/><br/>";
            $totos = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);

            $spools = array();
            $smpools = array();
            $stotos = array();
            foreach($pools as $pool){
                $key = $pool->drawno;
                if ($pool->is_mpools == 'N'){
                    if(isset($spools[$key]) == false) $spools[$key] = "";
                    $spools[$key] .= "<div class='col-sm-8 al-center result'>$pool->price</div><div class='col-sm-4 al-center result1'>$pool->result</div>";
                }else{
                    $price = $pool->price;
                    if(isset($smpools[$key]) == false) $smpools[$key] = array();
                    if(isset($smpools[$key][$price]) == false) $smpools[$key][$price] = "";
                    $smpools[$key][$price] .= "<div class='col-sm-6 al-center'>$pool->result</div>";
                }
            }
            $pools = NULL;

            foreach($totos as $toto){
                $key = $toto->drawno;
                if (isset($stotos[$key]) == false) $stotos[$key] = "";
                $stotos[$key] .= "<div class='panel panel-default'><div class='panel-heading al-center'>Winning Numbers</div><div class='panel-body row'>
                                                            <div class='col-sm-2 al-center'>$toto->result1</div>
                                                            <div class='col-sm-2 al-center'>$toto->result2</div>
                                                            <div class='col-sm-2 al-center'>$toto->result3</div>
                                                            <div class='col-sm-2 al-center'>$toto->result4</div>
                                                            <div class='col-sm-2 al-center'>$toto->result5</div>
                                                            <div class='col-sm-2 al-center'>$toto->result6</div>
                                                        </div></div>";

                $stotos[$key] .= "<div class='panel panel-default' style='margin-botton:0px;'><div class='panel-heading al-center'>Additional Numbers</div><div class='panel-body al-center'>$toto->additional</div></div>";
            }
            $totos = NULL;

            foreach($drawnos as $drawno){
                $key = $drawno->drawno;
                $title = "<h4>Draw No $key " . date("D d, F Y", strtotime($drawno->date_)) . "</h4>";
                $body = "";
                if (isset($spools[$key])){
                    $body .= "<div class='result-wraper'>$spools[$key]<div class='clearfix'></div></div>";
                }
                if(isset($smpools[$key])){
                    foreach($smpools[$key] as $key1=>$val1){
                        $body .= "<div class='result-toto'><div class='al-center header'>$key1</div><div class='row'>$val1</div></div>";
                    }
                }
                if (isset($stotos[$key])){
                    $body .= $stotos[$key];
                }
                if ($body !== "") $result .= "<div class='col-sm-6'>" . $title . $body . "<hr/></div>";
            }
            $ct = $this->paging->getPagingControl("/index", $pageNumber);
            if ($ct !== ""){
                $result .= "<div class='row' style='margin-top:10px;'><div class='pull-right'>$ct</div></div>";
            }
        }else{
            $result = "<div class='col-sm-12 al-center'>No Result found!</div>";
        }
        return $result;
    }
    
    function sortArray($array){
        $ar = array();
        $keys = array_keys($array);
        $cnt = count($keys);
        for ($i=0; $i<$cnt; $i++){
            for($k=($i+1); $k<$cnt; $k++){
                if ($keys[$k] > $keys[$i]){
                    $big = $keys[$i];
                    $keys[$i] = $keys[$k];
                    $keys[$k] = $big;
                }
            }
        }
        
        foreach($keys as $k){
            $ar[$k] = $array[$k];
        }
        
        return $ar;
    }
}

?>