<?php

class categoryModel
{
    private $db;
    private $paging;
    private $items;
    public function init()
    {
        $this->items = $this->model->ajax->getItemsPerPage();
        $this->db = new DATABASE(DB_HOST, DB_NAME, DB_USER, DB_PASS);
        $this->paging = new PAGING(DB_HOST, DB_NAME, DB_USER, DB_PASS, $this->items);
    }
    
    function getData(){
        $catId = $this->url->getSubPage("token");
        if ($catId !== null){
            $catId = $this->ctrl->getName($catId);
            if (is_numeric($catId) === false) $catId = NULL;
        }
        
        $this->getCategory($catId);
    }
            
    function getCategory($catId = NULL){
        if ($catId == NULL)
            $sql = "SELECT * FROM tbl_category where cat_parent_id = :id  ORDER BY cat_parent_id,cat_name";
        else
            $sql = "SELECT * FROM tbl_category where cat_parent_id = :id ORDER BY cat_parent_id,cat_name";
            
        $data = array(":id"=>$catId);
        $pageNum = $this->url->getSubPage(1);
        if (is_numeric($pageNum) === false || $pageNum < 1) $pageNum = 1;
        $rows = $this->paging->executeQuery($sql, $data, $pageNum);
        
        if (count($rows) > 0){
            foreach ($rows as $row){
                $id = $row["cat_id"];
                $name = $row["cat_name"];
                $desc = $row["cat_description"];
                $img = $row["cat_image"];
                if ($img != "" && file_exists(_CHILE_HTDOCS_."images/category/$img")){
                    $img = _CHILD_SITE_ . "images/category/$img";
                }else{
                    $img = "";
                }
                $eid = $this->ctrl->$id;
                
                if ($catId == 0){
                    $name = "<a href='" . SITE . "/catalog/category.aspx?token=$eid'>$name</a>";
                }

                echo "<tr>
                                        <td>
                                            <input type='checkbox' class='chk' id='$eid'/>
                                        </td>
                                        <td>$name</td>
                                        <td>$desc</td>
                                        <td>
    <img src='$img' class='thumb' />
                                        </td>
                                        <td>
                                                <span class='glyphicon glyphicon-pencil point' style='padding-right:10px;' data-title='Edit' title='Edit'></span>
                                                <span class='glyphicon glyphicon-trash point' data-title='Delete' title='Delete'></span>
                                        </td>
                                    </tr>";
            }
            
            if ($this->paging->getPageCount($sql,$data) > 1){
                echo "<tr><td colspan='5' id='paging' style='text-align:right;'>" . $this->paging->getPagingControl("/catalog/category.aspx", $pageNum, "/?token=".$this->url->getSubPage("token")) . "</td></tr>";
            }
                echo "<script>
                                $('#paging').children('input[type=button]').each(
                                    function (){ 
                                        $(this).addClass('btn btn-default');
                                        $(this).css('margin-left', '5px');
                                    }
                                );
                                $('#txtPagingControl').addClass('textbox');
                                $('#txtPagingControl').css('width','220px');
                                $('#txtPagingControl').css('margin-left','5px');
                                
$(document).ready(function(){
                                $('span[data-title=Edit]').each(function(){
                                    $(this).click(function(){
                                        $('#blanket').css('display', 'table');
                                        var a = $(this).parent().parent();
                                        var b = '/ajax.htm/category/edit/' + a.find('input[type=checkbox]').attr('id');

                                        $.ajax({url : b}).done(function(msg){
                                            $('#blanket').css('display', 'none');
                                            if (msg === '0'){
                                                show('Error', 'You have choosen an incorrect category!<br/>Please try again!');
                                            }else{
                                                $('#" . $this->ctrl->main . "').html(msg);
                                                $('#del').html('CANCEL');
                                                $('#" . $this->ctrl->btnAdd . "').hide(100);
                                                $('#pnFooter').hide(100);
                                                $('#btnDelete').removeClass('disabled');
                                                $('#brandName').html('Edit Category');
                                            }
                                        });
                                    });
                                });
                                $('span[data-title=Delete]').each(function(){
                                    $(this).click(function(){
                                        $('.chkAll').prop('checked', false);
                                        $('.chk').each(function(){
                                            $(this).prop('checked', false);
                                        });
                                         var a = $(this).parent().parent();
                                         a.find('input[type=checkbox]').prop('checked', true);
                                         " . $this->ctrl->btnDelete_click . "();
                                    });
                                });
});
                            </script>";
        }else{
            echo "<tr><td colspan='5' class='al-center'>No Records!</td></tr>";
        }
    }
    
    function doDeleteCategory(){
        $ids = explode(";", $this->ctrl->ids->getText());
        $cnt = count($ids);
        for ($i = 0; $i < $cnt; $i++){
            $a = $this->ctrl->getName($ids[$i]);
            if (is_numeric($a)){
                $this->removeImageByCategoryId($a);
                $sql = "DELETE FROM tbl_category WHERE cat_id=:id limit 1";
                $data = array(":id"=>$a);
                $b = $this->db->executeUpdate($sql, $data);
                if ($b > 0) $this->model->log->addLog("Delete Category[ID:$a]");
            }
        }
        echo $cnt;
    }
    
    function removeImageByCategoryId($catId){
        $sql = "SELECT * FROM tbl_category where cat_id=:id limit 1";
        $data = array(":id"=>$catId);
        $row = $this->db->executeQuery($sql, $data);
        if (count($row) > 0){
            $row = $row[0];
            $img = $row["cat_image"];
            $img = _CHILE_HTDOCS_ . "images/category/$img";
            if (file_exists($img) && is_file($img)){
                unlink($img);
            }
        }
    }
            
    function doAddCategory(){
        $name = trim($this->ctrl->txtName->getText());
        $desc = trim($this->ctrl->txtText->getText());
        if ($name === ""){
            echo "Name cannot be empty";
            return;
        }
        $id = $this->ctrl->getName($this->url->getSubPage("token"));
        if (is_numeric($id) === FALSE) $id = 0;
        
        $img = $this->model->upload->uploadImage((string)$this->ctrl->fileinput, "images/category/", 300);
        $sql = "INSERT INTO tbl_category(cat_parent_id,cat_name,cat_description,cat_image) VALUES(:id,:name,:content,:picture)";
        $data = array(":id"=>$id, ":name"=>$name, ":content"=>$desc, ":picture"=>$img);
        $a = $this->db->executeUpdate($sql, $data);
        if ($a > 0) $this->model->log->addLog("Add New Category[NAME:$name]");
        echo $a;
    }
    
    function getEditCategory($id){
        if (is_numeric($id) == FALSE){
            return null;
        }
        $sql = "select cat_id, cat_name, cat_description, cat_image from tbl_category where cat_id = :id limit 1";
        $data = array(":id"=>$id);
        $rows = $this->db->executeQuery($sql, $data, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            $rows = $rows[0];
            return $rows;
        }
        return null;
    }
    
    function doEditCategory(){
        $id = $this->ctrl->getName($this->url->getSubPage("token"));
        if (is_numeric($id) === true){
            $name = trim($this->ctrl->txtName->getText());
            $desc = trim($this->ctrl->txtText->getText());
            if ($name === ""){
                echo "Name cannot be empty";
                return;
            }
            $img = "";
            if (isset($_FILES[(string)$this->ctrl->fileinput])){
                $this->removeImageByCategoryId($id);
                $img = $this->model->upload->uploadImage((string)$this->ctrl->fileinput, "images/category/", 300);
            }
            
            $sSql = "";
            if ($img !== ""){
                $sSql = ", cat_image=:img";
                $data = array(":name"=>$name, ":des"=>$desc, ":img"=>$img, ":id"=>$id);
            }else{
                $data = array(":name"=>$name, ":des"=>$desc, ":id"=>$id);
            }
            
            $sql = "update tbl_category set cat_name = :name, cat_description = :des $sSql where  cat_id = :id limit 1";
            $a = $this->db->executeUpdate($sql, $data);
            if ($a > 0) $this->model->log->addLog("Edit Category[ID:$id]");
            echo $a;
        }else
            echo "Invalid category id!";
    }
    
    
}

?>