<?php

include_once dirname(__DIR__).'/Server/SERVER.php';

if (!isset($_SESSION)){
    @session_name("_DalyPhp_KhmerFrameWork");
    @session_write_close();
    @session_start();
}

if (!class_exists("SESSION")){
    class SESSION{
        public function __construct(){
        }
        
        public function &__get($name)
        {
            $this->checkSecurity();
            
            return $_SESSION[$name];
        }

        public function &get($name){
            $this->checkSecurity();
            
            return $_SESSION[$name];
        }

        public function __set($name, $value)
        {
            $this->checkSecurity();
            
            $_SESSION[$name] = $value;
        }
        
        private function checkSecurity(){
            $this->verifyExpiredSession();
            
            if (DISABLE_IP_FILTER === FALSE){
                $this->validateIpAddress();
                
            }
        }

                /**
         * Destroy session of the current Name
         * @param string $name name of session
         * @note you cannot use array of session on this
         */
        public function destroy($name = ""){
            if ($name !== ""){
                if(isset($_SESSION[$name]))
                    unset($_SESSION[$name]);
            }else{
                if(isset($_SESSION)){
                    @session_destroy();
                    @session_write_close();
                    @session_start();
		    @session_regenerate_id(TRUE);
                }
            }
        }

        //Make sure that session are safe with current ip address
        private function validateIpAddress()
        {
            $server = new SERVER();
            $ipAddress = $server->getIP();

            if (isset($_SESSION['dafdasjfwejrlkcvnoierwuqhksdj1234']))
            {
                if ($_SESSION['dafdasjfwejrlkcvnoierwuqhksdj1234'] != $ipAddress)
                {
                    $this->destroy();
                }
            }
            else
            {
                $_SESSION['dafdasjfwejrlkcvnoierwuqhksdj1234'] = $ipAddress;
            }
        }
        
        //Verify to make sure that session are not currently use with 2 webbrowser
        private function verifyUserAgent(){
            /*$param = "dara.framework.userAgent_168";
            $server = new SERVER();
            if (!isset($_SESSION[$param])){
                $_SESSION[$param] = $server->get(SERVER::HTTP_USER_AGENT);
            }else{
                $userAgent = $server->get(SERVER::HTTP_USER_AGENT);
                if ($_SERVER[$param] !== $userAgent){
                    $this->destroy();
                }
                unset($userAgent);
            }
            unset($param);
            unset($server);*/
        }

        //Verify to make sure that user is currently use
        public function verifyExpiredSession(){
            if (!isset($_SESSION['dara.session.expireSec'])){
                $_SESSION['dara.session.expireSec'] = time();
            }else{
                if(time() - $_SESSION['dara.session.expireSec'] > 900){
                    $this->destroy();
                    
                    if (SHOW_SESSION_ERROR == true){
                        echo "Your session is expired, this page will be refresh in <span id='time'>4</span>. Or <a href='#' onclick='javascript:window.location.reload();'>click here</a> to refresh your page.<script>setInterval(function(){var a=parseInt(document.getElementById('time').innerHTML);a=a-1;document.getElementById('time').innerHTML=a;if(a<1)window.location.reload();}, 1000);</script>"; exit();
                    }else 
                        @header("refresh:0");
                }else{
                    $_SESSION['dara.session.expireSec'] = time();
                }
            }
        }
    }
}
?>