<?php
    include_once dirname(__DIR__).'/Url/URL.php';
    include_once dirname(__DIR__).'/Session/SESSION.php';
    include_once dirname(__DIR__).'/Encrypt/ENCRYPT.php';

if (!class_exists("CONTROLS")){
    class CONTROLS{
        private $controls;
        private $sub;
        private $session;

        public function __construct(){
            $this->controls = &$_SESSION["ctrl_php_dara_frmWork168"];
            $this->sub = &$_SESSION["ctrl_php_dara_frmWork168SUB"];
            $this->session = new SESSION();
        }
                
        function encrypt($str){
            $enc = new ENCRYPT();
            $result = $enc->encrypt($str, $enc->generateKey(9));
            
            $result = str_replace("=", "_equ_", $result);
            $result = str_replace("-", "_min_", $result);
            $result = str_replace("+", "_pls_", $result);
            
            return $result;
	}

	public function decrypt($str){
            $str = str_replace("_min_", "-", $str);
            $str = str_replace("_equ_", "=", $str);
            $str = str_replace("_pls_", "+", $str);
            
            $enc = new ENCRYPT();
            
            return $enc->decrypt($str, $enc->generateKey(9));
	}

        /**
         * get : use to get control name with random string
         * @param type $name name of controls 
         * @return String
         * @Description Control name in random string
         */
        public function get($name){
            $abc = $this->randomCtrl();
            $sub = $this->randomSUB();
            $name = $this->encrypt($name);
            $txt = new Text($abc.$name.$sub);
            return $txt;
        }
        
        /**
         * Get Name of the control
         * @return string
         * @Description Get the control name
         */
        public function getName($strControlClientName){
            $ctrl_orName = $strControlClientName;
            $strControlClientName = substr($strControlClientName, strlen($this->controls));
            $cnt = strlen($strControlClientName) - strlen($this->sub);
            $result = "";
            for ($i = 0; $i < $cnt; $i++)
                $result .= $strControlClientName[$i];

            $strControlClientName = $this->decrypt($result);
            if ($strControlClientName === $ctrl_orName) $strControlClientName = null;
            //$strControlClientName = str_replace($this->controls, "", $strControlClientName);
            //$strControlClientName = str_replace($this->sub, "", $strControlClientName);
           
            return $strControlClientName;
        }

        private function randomCtrl(){
            if ($this->controls === NULL)
            {
                $str1 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                $s = "";
                $str2 = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_";
                for ($i=0; $i<4; $i++){
                    $rnd = rand(0, strlen($str1)-1);
                    $s .= $str1[$rnd];
                }
                for ($i=0; $i<20; $i++){
                    $rnd = rand(0, strlen($str2)-1);
                    $s .= $str2[$rnd];
                }
               $this->controls = $s;
            }

            return $this->controls;
        }
        
        private function randomSUB(){
            $leng = "56789";
            $l = rand(0, strlen($leng)-1);
            $l += 10;
            if ($this->sub === NULL){
                $leng = "abcdefghijklmnopqrstuvwABCDEFGHIJKLMQRSTUVWXYZ";
                $s = "";
                for ($i=0; $i < $l; $i++){
                    $s .= $leng[rand(0, strlen($leng) - 1)];
                }
                $this->sub = $s;
            }
            return $this->sub;
        }

        public function __get($name)
        {
            $abc = $this->randomCtrl();
            $sub = $this->randomSUB();
            $name = $this->encrypt($name);
            $txt = new Text($abc.$name.$sub);
            return $txt;
        }
        
        function javascript_escape($str) {
            $new_str = '';

            $str_len = strlen($str);
            for($i = 0; $i < $str_len; $i++) {
                $new_str .= '\\x' . dechex(ord(substr($str, $i, 1)));
            }

            return $new_str;
        }
        
        /*public function __toString()
        {
            return $this->randomCtrl($this->name);
        }*/

        /**
         * clear : use to clear all controls
         */
        public function clear(){
            unset($_SESSION["ctrl_php_dara_frmWork168"]);
            $this->controls = $_SESSION["ctrl_php_dara_frmWork168"];
        }
    }
}

if (!class_exists("Text")){
    class Text{
        private $name;
        private $sub;
        private $controls;

        public function __construct($name)
        {
            $this->name = $name;
            $this->controls = &$_SESSION["ctrl_php_dara_frmWork168"];
            $this->sub = &$_SESSION["ctrl_php_dara_frmWork168SUB"];
        }
        
        /**
         * Get Name of the control
         * @return string
         * @Description Get the control name
         */
        public function getName(){
            $strControlClientName = $this->name;
            $ctrl_orName = $strControlClientName;
            $strControlClientName = substr($strControlClientName, strlen($this->controls));
            $cnt = strlen($strControlClientName) - strlen($this->sub);
            $result = "";
            for ($i = 0; $i < $cnt; $i++)
                $result .= $strControlClientName[$i];

            $strControlClientName = $this->decrypt($result);
            if ($strControlClientName === $ctrl_orName) $strControlClientName = null;
            //$strControlClientName = str_replace($this->controls, "", $strControlClientName);
            //$strControlClientName = str_replace($this->sub, "", $strControlClientName);
           
            return $strControlClientName;
        }
        
        public function __get($name) {
            if (isset($_POST[$this->name."V".$name]))
                return $_POST[$this->name."V".$name];
            return NULL;
        }
        
        public function __set($name, $value) {
            $_POST[$this->name."V".$name] = $value;
        }

        public function getText(){
            $str = $this->name;
            if (isset($_POST[$str])){
                $a = $_POST[$str];
                if (is_array($a) == TRUE) $a = end($a);
                if (strpos($a, ",") !== false){
                    $b = str_replace(",", "", $a);
                    if (preg_match("/^\d+$/", $b)) $a = $b;
                }
                return trim($a);
            }
            
            return null;
        }
        
        /**
         * Get Decoded Text
         * @return String
         */
        public function getDText(){
            $strControlClientName = $this->getText();
            $ctrl_orName = $strControlClientName;
            $strControlClientName = substr($strControlClientName, strlen($this->controls));
            $cnt = strlen($strControlClientName) - strlen($this->sub);
            $result = "";
            for ($i = 0; $i < $cnt; $i++)
                $result .= $strControlClientName[$i];

            $strControlClientName = $this->decrypt($result);
            if ($strControlClientName === $ctrl_orName) $strControlClientName = null;
            return $strControlClientName;
        }


        public function setText($text){
            $str = $this->name;
            $_POST[$str] = $text; 
        }

        public function __toString()
        {
            $str = $this->name;
            $ctl = new CONTROLS();
            return $str;
        }
        
        private function decrypt($str){
            $str = str_replace("_min_", "-", $str);
            $str = str_replace("_equ_", "=", $str);
            $str = str_replace("_pls_", "+", $str);
            
            $enc = new ENCRYPT();
            
            return $enc->decrypt($str, $enc->generateKey(9));
	   }
    
    }
}
?>