<?php

class gModel
{
    private $db, $paging;
    
    const fd = 1;
    const toto = 2;

    function init(){
        $this->db = new DATABASE(DB_HOST, DB_NAME, DB_USER, DB_PASS);
        $this->paging = new PAGING(DB_HOST, DB_NAME, DB_USER, DB_PASS, 1);
        if ($this->session->lang == "ch") include dirname(__DIR__) . "/View/language/ch.php";
        else include dirname(__DIR__) . "/View/language/en.php";
    }

    function getSetting($settingId = 1){
        $sql = "select * from tbl_setting where sc_id=:id limit 1";
        $a = $this->db->executeQuery($sql, array(":id"=>$settingId), PDO::FETCH_OBJ);
        if (count($a) > 0) return $a[0];
        return NULL;
    }
    function is4dOnly(){
        $result = $this->getSetting(1);
        if($result != NULL){
            if ($result->sc_4d_m_length == 0) {
                return 3;
            } else {
                return 5;
            }
        }else
            return NULL;
    }
    
    function getToto(){
        $this->paging->setItemsPerPage(2);
        $pageNumber = $this->url->getSubPage(1);
        $sql = "select a.date_, b.* from (
                                select drawno, date_ from tbl_draw a where date_ < :now
                            ) a inner join tbl_toto b on a.drawno=b.drawno";
        $rows = $this->paging->executeQuery($sql, array(":now"=>date("Y-m-d")), $pageNumber, PDO::FETCH_OBJ);
        
        $result = "";
        if (count($rows) > 0){
            $i = 0;
            foreach($rows as $row){
                $a = $this->getWinnerShare($i);
               
                $i++;
                $result .="<div class='col-sm-6'><h5><b>{$this->lang['Draw No']} $row->drawno <br/>" . date("l d M y", strtotime($row->date_)) . "</b></h5>
                                <div class='panel panel-red'>
                                    <div class='panel-heading al-center'><b>Winning Numbers</b></div>
                                    <div class='panel-body row'>
                                        <div class='col-sm-2 al-center'><b>$row->result1</b></div>
                                        <div class='col-sm-2 al-center'><b>$row->result2</b></div>
                                        <div class='col-sm-2 al-center'><b>$row->result3</b></div>
                                        <div class='col-sm-2 al-center'><b>$row->result4</b></div>
                                        <div class='col-sm-2 al-center'><b>$row->result5</b></div>
                                        <div class='col-sm-2 al-center'><b>$row->result6</b></div>
                                    </div>
                                </div>
                                <div class='panel panel-red' style='margin-bottom:25px;'>
                                    <div class='panel-heading al-center'><b>Additional Number</b></div>
                                    <div class='panel-body al-center'>
                                        <b>$row->additional</b>
                                    </div>
                                </div>$a</div>";
            }
            /*$a = $this->paging->getPagingControl("/toto", $pageNumber);
            if ($a !== ""){
                $result .= "<div class='clearfix'></div><hr/><div class='col-sm-12 al-right'>$a</div>";
            }*/
        }else{
            echo "<div class='col-sm-12 al-center'>No Result Found!</div>";
        }
        return $result;
    }
    
    function get4d($pageNumber = 1){
        $this->paging->setItemsPerPage(1);
        //$pageNumber = $this->url->getSubPage(1);
        $sql = "select drawno, date_ from tbl_draw where date_ < :now and drawno in (select drawno from tbl_pools) order by date_ desc limit 1";
        $rows = $this->db->executeQuery($sql, array(":now"=>date("Y-m-d") . " 00:00:00"), PDO::FETCH_OBJ);
        if (count($rows) > 0){
            $as = "";
            foreach($rows as $row) $as .= "drawno=$row->drawno or ";
            $as = substr($as, 0, strlen($as)-strlen("or "));
            $sql = "select * from (
                                select a.date_, b.* from (
                                        select drawno, date_ from tbl_draw where $as
                                ) a inner join tbl_pools b on a.drawno=b.drawno
                                ) c inner join tbl_price d on c.priceid=d.priceid
                                order by c.priceid asc, c.date_, c.result desc";
            $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
        }else{ $rows = array(); }

        
        $result = "";
        if (count($rows) > 0){
            $date = array();
            $multiple = array();
            $single = array();
            $drawno = array();
            $i = 0;
            $priceId = 0;
            
            foreach($rows as $row){
                $key = str_replace("-", "", $row->date_);                
                if(isset($date[$key]) == false) $date[$key] = $row->date_;
                if(isset($drawno[$key]) == false) $drawno[$key] = $row->drawno;
                for($pp = 0; $pp < 10; $pp++){
                    $row->result = str_replace($pp, "<div class='num'>$pp</div>", $row->result);
                }
                if ($row->is_mpools == "N"){
                    if (isset($single[$key]) == false) $single[$key] = "";
                    $single[$key] .= "<div class='prize'><div class='header'>$row->price</div><div class='result'>$row->result</div></div>";
                }else{
                    $priceId = $row->price;
                    if(isset($multiple[$key]) == false) $multiple[$key] = array();
                    if(isset($multiple[$key][$priceId]) == false) $multiple[$key][$priceId] = "";
                    $multiple[$key][$priceId] .= "<div class='result'>$row->result</div>";
                }
            }
            
            $date = $this->sortArray($date);
            
            foreach($date as $d=>$n){
                //Generate Single results
                $tm = strtotime($n);
                $dName = $this->lang[date("D", $tm)] . date(" d/m/y", $tm);
                $dd = date("Y-m-d", $tm);
                //<div class='header2'>Toto 4D</div><div class='prize-payment'>{$this->lang['Prize payments guaranteed in full']}</div>
                $result .= "<div class='draw-date'><div>{$this->lang['Updated on']}: $dName</div> <div>{$this->lang['Draw No']}: $drawno[$d]</div></div>";
                $result .= "<div class='all-result'><a href='/search?s=$dd'>See all results</a></div>";
                if (isset($single[$d])){
                    $result .= "<div class='single has-margin'>" . $single[$d] . "</div>";
                }
                if (isset($multiple[$d])){
                    $result .= "<div class='multi'>";
                    foreach($multiple[$d] as $key=>$val){
                        $result .= "<div class='prize'><div class='header'>$key</div>$val</div>" . PHP_EOL;
                    }
                    $result .= "</div>";
                }
            }
            if ($i !== 0) $result.="<div class='clearfix'></div><hr/></div>";
        }else{
            $result .= "<div class='col-sm-12 al-center'>{$this->lang['No Result found']}!</div>";
        }
        return $result;
    }
    
    function getResult($pageNumber = 1){
        $this->paging->setItemsPerPage(6);
        $sql = "select drawno, date_ from tbl_draw where date_ < :now and drawno in (select drawno from tbl_pools) order by date_ desc";
        $rows = $this->paging->executeQuery($sql, array(":now"=>date("Y-m-d") . " 00:00:00"), $pageNumber, PDO::FETCH_OBJ);

        if (count($rows) > 0){
            $as = "";
            foreach($rows as $row) $as .= "drawno=$row->drawno or ";
            $as = substr($as, 0, strlen($as)-strlen("or "));
            $sql = "select * from (
                                select a.date_, b.* from (
                                        select drawno, date_ from tbl_draw where $as
                                ) a inner join tbl_pools b on a.drawno=b.drawno
                                ) c inner join tbl_price d on c.priceid=d.priceid
                                where c.is_mpools = 'N'
                                order by c.priceid asc, c.date_, c.result desc";

            $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
        }else{ $rows = array(); }

        
        $result = "";
        if (count($rows) > 0){
            $date = array();
            $multiple = array();
            $single = array();
            $drawno = array();
            $i = 0;
            $priceId = 0;
            
            foreach($rows as $row){
                $key = str_replace("-", "", $row->date_);                
                if(isset($date[$key]) == false) $date[$key] = $row->date_;
                if(isset($drawno[$key]) == false) $drawno[$key] = $row->drawno;
                for($pp = 0; $pp < 10; $pp++){
                    $row->result = str_replace($pp, "<div class='num'>$pp</div>", $row->result);
                }
                if ($row->is_mpools == "N"){
                    if (isset($single[$key]) == false) $single[$key] = "";
                    $single[$key] .= "<div class='prize'><div class='header'><div>$row->price</div></div><div class='result'>$row->result</div></div>";
                }else{
                    $priceId = $row->price;
                    if(isset($multiple[$key]) == false) $multiple[$key] = array();
                    if(isset($multiple[$key][$priceId]) == false) $multiple[$key][$priceId] = "";
                    $multiple[$key][$priceId] .= "<div class='result'>$row->result</div>";
                }
            }
            
            $date = $this->sortArray($date);
            
            foreach($date as $d=>$n){
                //Generate Single results
                $tm = strtotime($n);
                $dName = $this->lang[date("D", $tm)] . date(" d/m/y", $tm);
                $dd = date("Y-m-d", $tm);
                // $result .= "<div class='draw-date'><div>{$this->lang['Draw Date']}: $dName</div> <div>{$this->lang['Draw No']}: $drawno[$d]</div></div>";
                if (isset($single[$d])){
                    $result .= "<div class='single'>" . $single[$d] . "</div><div class='more-result'><a href='/search?s=$dd'>More Result &gt;&gt;&gt;</a></div>";
                }
                $result.="<hr/>";
            }
            
            $ctr = $this->paging->getPagingControl("/result", $pageNumber);
            if ($ctr != "") $result .= "<div class='paging'>$ctr</div>";
        }else{
            $result .= "<div class='col-sm-12 al-center'>{$this->lang['No Result found']}!</div>";
        }
        return $result;
    }
    function getFirstResult($pageNumber = 1){
        $this->paging->setItemsPerPage(12);
        $sql = "select drawno, date_ from tbl_draw where date_ < :now and drawno in (select drawno from tbl_pools) order by date_ desc";
        $rows = $this->paging->executeQuery($sql, array(":now"=>date("Y-m-d") . " 00:00:00"), $pageNumber, PDO::FETCH_OBJ);

        if (count($rows) > 0){
            $as = "";
            foreach($rows as $row) $as .= "drawno=$row->drawno or ";
            $as = substr($as, 0, strlen($as)-strlen("or "));
            $sql = "select * from (
                                select a.date_, b.* from (
                                        select drawno, date_ from tbl_draw where $as
                                ) a inner join tbl_pools b on a.drawno=b.drawno
                                ) c inner join tbl_price d on c.priceid=d.priceid
                                where c.is_mpools = 'N'
                                order by c.priceid asc, c.date_, c.result desc";

            $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
        }else{ $rows = array(); }

        
        $result = "";
        if (count($rows) > 0){
            $date = array();
            $multiple = array();
            $single = array();
            $drawno = array();
            $i = 0;
            $priceId = 0;
            
            foreach($rows as $row){
                $key = str_replace("-", "", $row->date_);                
                if(isset($date[$key]) == false) $date[$key] = $row->date_;
                if(isset($drawno[$key]) == false) $drawno[$key] = $row->drawno;
                for($pp = 0; $pp < 10; $pp++){
                    $row->result = str_replace($pp, "<div class='num'>$pp</div>", $row->result);
                }
                if ($row->is_mpools == "N"){
                    if (isset($single[$key]) == false) $single[$key] = "";
                    $single[$key] .= "<div class='prize'><div class='header'>$row->price</div><div class='result'>$row->result</div></div>";
                }else{
                    $priceId = $row->price;
                    if(isset($multiple[$key]) == false) $multiple[$key] = array();
                    if(isset($multiple[$key][$priceId]) == false) $multiple[$key][$priceId] = "";
                    $multiple[$key][$priceId] .= "<div class='result'>$row->result</div>";
                }
            }
            
            $date = $this->sortArray($date);
            
            foreach($date as $d=>$n){
                //Generate Single results
                $tm = strtotime($n);
                $dName = $this->lang[date("D", $tm)] . date(" d/m/y", $tm);
                $dd = date("Y-m-d", $tm);
                
                if (isset($single[$d])){
                    $result .= "<div class='single'>". $single[$d] ."<div class='draw-date'><div>Updated on $dName</div> </div>"."</div><div class='more-result'><a href='/search?s=$dd'>More Result &gt;&gt;&gt;</a></div>";
                }
            }
            
            $ctr = $this->paging->getPagingControl("/result", $pageNumber);
            if ($ctr != "") $result .= "<div class='paging'>$ctr</div>";
        }else{
            $result .= "<div class='col-sm-12 al-center'>{$this->lang['No Result found']}!</div>";
        }
        return $result;
    }      
    
    function search4d($key = "", $pageNumber = 1){
    if ($key == "" || $key == NULL) return $this->get4d($pageNumber);
        $this->paging->setItemsPerPage(35);
        $skey = "%" . urldecode(urldecode($key)) . "%";
        $sql = "select c.*, d.price, d.release_hour, d.delay_mn from (
                                select a.date_, b.* from (
                                        select drawno, date_ from tbl_draw where date_ < :now and drawno in (select drawno from tbl_pools)
                                ) a inner join tbl_pools b on a.drawno=b.drawno
                                ) c inner join tbl_price d on c.priceid=d.priceid
                                 where (result like :key or drawno like :key or cast(date_ as char(10)) like :key)
                                order by c.date_ desc, c.priceid asc";
        $data = array(":now"=>date("Y-m-d"), ":key"=>$skey);
        $rows = $this->paging->executeQuery($sql, $data, $pageNumber, PDO::FETCH_OBJ);
        $result = "";
        if (count($rows) > 0){
            $date = array();
            $multiple = array();
            $single = array();
            $drawno = array();
            $i = 0;
            $priceId = 0;
            foreach($rows as $row){
                $key = str_replace("-", "", $row->date_);                
                if(isset($date[$key]) == false) $date[$key] = $row->date_;
                if(isset($drawno[$key]) == false) $drawno[$key] = $row->drawno;
                for($pp = 0; $pp < 10; $pp++){
                    $row->result = str_replace($pp, "<div class='num'>$pp</div>", $row->result);
                }
                if ($row->is_mpools == "N"){
                    if (isset($single[$key]) == false) $single[$key] = "";
                    $single[$key] .= "<div class='prize'><div class='header'><div>$row->price</div></div><div class='result'>$row->result</div></div>";
                }else{
                    $priceId = $row->price;
                    if(isset($multiple[$key]) == false) $multiple[$key] = array();
                    if(isset($multiple[$key][$priceId]) == false) $multiple[$key][$priceId] = "";
                    $multiple[$key][$priceId] .= "<div class='result'>$row->result</div>";
                }
            }
            
            $date = $this->sortArray($date);
            
            foreach($date as $d=>$n){
                //Generate Single results
                $tm = strtotime($n);
                $dName = $this->lang[date("D", $tm)] . date(" d/m/y", $tm);
                $result .= "<div class='draw-date'><div>{$this->lang['Draw Date']}: $dName</div> <div>{$this->lang['Draw No']}: $drawno[$d]</div></div><div class='header2'>Toto 4D</div><div class='prize-payment'>{$this->lang['Prize payments guaranteed in full']}</div>";
                if (isset($single[$d])){
                    $result .= "<div class='single'>" . $single[$d] . "</div>";
                }
                if (isset($multiple[$d])){
                    $result .= "<div class='multi'>";
                    foreach($multiple[$d] as $key=>$val){
                        $result .= "<div class='prize'><div class='header'>$key</div>$val</div>" . PHP_EOL;
                    }
                    $result .= "</div><script>$('#content-wrapper').addClass('result-div');</script>";
                }
            }
            if ($i !== 0) $result.="<div class='clearfix'></div><hr/></div>";
        }else{
            $result .= "<div class='col-sm-12 al-center'>{$this->lang['No Result found']}!</div>";
        }
        return $result;
    }
            
    function get4dLiveDraw(){
        
        $this->paging->setItemsPerPage(3);
        $pageNumber = $this->url->getSubPage(1);
        $sql = "select drawno, date_ from tbl_draw where date_ = :now and drawno in (select drawno from tbl_pools) order by date_ desc";
        $rows = $this->paging->executeQuery($sql, array(":now"=>date("Y-m-d") . " 00:00:00"), $pageNumber, PDO::FETCH_OBJ);
        $nextDraw = "";
        
        if (count($rows) > 0){
            $as = "";
            foreach($rows as $row) $as .= "drawno=$row->drawno or ";
            $as = substr($as, 0, strlen($as)-strlen("or "));
            $sql = "select * from (
                                select a.date_, b.* from (
                                        select drawno, date_ from tbl_draw where $as
                                ) a inner join tbl_pools b on a.drawno=b.drawno
                                ) c inner join tbl_price d on c.priceid=d.priceid
                                order by c.priceid asc, c.date_, c.result desc";
            
            $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
            
            foreach($rows as $row){
                    $a = (strtotime(date("H:i:s")) - strtotime($row->release_hour)) / 60;// round((strtotime(date("H:i:s")) - strtotime($row->release_hour)) / 60, 0, PHP_ROUND_HALF_DOWN );
                    if ($row->delay_mn > 0){
                        $a = $a / $row->delay_mn; //round($a / $row->delay_mn, 0, PHP_ROUND_HALF_DOWN);
                    }
                    
                    $today = date("Y-m-d");
                    $this_time = date("His");
                    $rHour = str_replace(":", "", $row->release_hour);
                    $b = $row->result;
                    if ($today == $row->date_ && ($row->delay_mn > 0 || $this_time < $rHour)){
                        for ($i = 0; $i < strlen($b); $i++){
                            if ($i > $a){
                                $b[$i] = "x";
                            }
                        }
                    }
                    
                $row->result = $b;
            }
            
            $nextDraw .= $this->getNextDrawText($rows);
        }else{ $rows = array(); }
        
        $result = "";
        if (count($rows) > 0){
            $date = array();
            $multiple = array();
            $single = array();
            $drawno = array();
            $i = 0;
            $priceId = 0;
            
            foreach($rows as $row){
                $key = str_replace("-", "", $row->date_);                
                if(isset($date[$key]) == false) $date[$key] = $row->date_;
                if(isset($drawno[$key]) == false) $drawno[$key] = $row->drawno;
                for($pp = 0; $pp < 10; $pp++){
                    $row->result = str_replace($pp, "<div class='num'>$pp</div>", $row->result);
                }
                $row->result = str_replace("x", "<div class='num'>x</div>", $row->result);
                
                if ($row->is_mpools == "N"){
                    if (isset($single[$key]) == false) $single[$key] = "";
                    $single[$key] .= "<div class='prize'><div class='header'><div>$row->price</div></div><div class='result'>$row->result</div></div>";
                }else{
                    $priceId = $row->price;
                    if(isset($multiple[$key]) == false) $multiple[$key] = array();
                    if(isset($multiple[$key][$priceId]) == false) $multiple[$key][$priceId] = "";
                    $multiple[$key][$priceId] .= "<div class='result'>$row->result</div>";
                }
            }
            
            $date = $this->sortArray($date);
            
            foreach($date as $d=>$n){
                //Generate Single results
                $tm = strtotime($n);
                $dName = $this->lang[date("D", $tm)] . date(" d/m/y", $tm);
                $result .= "<div class='draw-date'><div>{$this->lang['Draw Date']}: $dName</div> <div>{$this->lang['Draw No']}: $drawno[$d]</div></div>";
                if (isset($single[$d])){
                    $result .= "<div class='single'>" . $single[$d] . "</div>";
                }
            }
            
            
        }else{
            
            $check = $this->is4dOnly();
            if($check != NULL){
                
               $result .= "<div class='al-center' style='font-weight:bold;'><br/><br/>Result will be <br/> released on " . date('d/m/y') . "<br /> at ";
               if($check == 3){
                   
                   $sql = "select release_hour from tbl_price where upper(is_mpools) = 'N' order by release_hour asc limit 1";
                   $r = $this->db->executeScalare($sql);
                   if($r != NULL){
                       $result .= $r;
                       
                   }
               }
               else{
                  $sql = "select release_hour from tbl_price where upper(is_mpools) = 'Y' order by release_hour asc limit 1";
                  $r = $this->db->executeScalare($sql);
                  if($r != NULL){
                       $result .= $r;                       
                   }
               }
               $result .= "</div>";
            }else{
                
            }   
        }
        return $result;
    }
    
    function getNextDrawText($data){
        $sql = "select * from tbl_price";
        $prices = $this->db->executeQuery($sql, array(":now"=>date("H:i:s")), PDO::FETCH_OBJ);
       
        $result = "";
        if(count($data) > 0){
            //Get Result Type and price
            $cnt = 0;
            $results[] = array();
            foreach($data as $row){
                $a = (strtotime(date("H:i:s")) - strtotime($row->release_hour)) / 60;//round((strtotime(date("H:i:s")) - strtotime($row->release_hour)) / 60, 0, PHP_ROUND_HALF_DOWN );
                if ($row->delay_mn > 0){
                    $a = $a / $row->delay_mn;//round($a / $row->delay_mn, 0, PHP_ROUND_HALF_DOWN);
                }
                
                $today = date("Y-m-d");
                $this_time = date("His");
                $rHour = str_replace(":", "", $row->release_hour);
                $b = trim($row->result);
                if ($today == $row->date_ && ($row->delay_mn > 0 || $this_time < $rHour)){
                    for ($i = 0; $i < strlen($b); $i++){
                        if ($i > $a){
                            $results[$cnt][0] = $row->release_hour;
                            $results[$cnt][1] = $row->delay_mn;
                            $results[$cnt][2] = $i + 1;
                            $cnt++;
                            break;
                        }
                    }   
                }
                
            }
            
            if ($cnt == 0){//Work if the result will be released on next day
                $a = str_replace(":", "", $prices[0]->release_hour);
                $hour = $prices[0]->release_hour;
                foreach($prices as $price){
                    $b = str_replace(":", "", $price->release_hour);
                    if ($a > $b){ 
                        $a = $b;
                        $hour = $price->release_hour;
                    }
                }
                $result = date("Y-m-d", strtotime(date("Y-m-d"). "+1 day")) . " " . date("H:i", strtotime('2014-02-01 '.$hour));
            }else{ //Work if the result will be released on today
                $a = str_replace(":", "", $results[0][0]);
                $hour = $results[0][0];
                foreach($results as $re){
                     $b = $re[0];//str_replace(":", "", $re[0]);
                    for ($i = 1; $i < $re[2]; $i++){
                        $b = date("H:i", strtotime("2014-02-01 " . $b . " +{$re[1]} minute"));
                    }
                    
                    $c = str_replace(":", "", $b);
                    if ($a > $c){
                        $a = $c;
                        $hour = $b;//$re[0];
                    }
                }
                $result = date("Y-m-d") . " $hour";
            }
        }
        //$result = date("Y-m-d H:i:s", strtotime($result . " -5hours"));
        $date = explode(" ", $result);
        $hour = $date[1];
        $date = $date[0];
        return "<div id='next_draw'><div><span id='next_draw_text'>{$this->lang['Next Result will be held on']}</span><span id='next_draw_date'>" . $date . "</span> <span id='next_draw_hour'>" . $hour . "</span></div></div>";
    }
    
    function search4DByDateName($dateName, $pageNumber = 1){
        $this->paging->setItemsPerPage(4);
        $sql = "select * from (
                                    select dayid from tbl_day where LOWER(dayname) = lower(:name) limit 1
                            ) a inner join (
                                    select date_, drawno, day_id from tbl_draw where date_ < :now
                            ) b on a.dayid=b.day_id order by date_ desc";
        $data = array(":name"=>$dateName, ":now"=>date("Y-m-d"));
        $rows = $this->paging->executeQuery($sql, $data, $pageNumber, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            $as = "";
            foreach($rows as $row) $as .= "drawno=$row->drawno or ";
            $as = substr($as, 0, strlen($as)-strlen("or "));
            $sql = "select * from (
                                select a.date_, b.* from (
                                        select drawno, date_ from tbl_draw where $as
                                ) a inner join tbl_pools b on a.drawno=b.drawno
                                ) c inner join tbl_price d on c.priceid=d.priceid
                                order by c.priceid asc, c.date_, c.result desc";

            $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
        }else{ $rows = array(); }

        
        $result = "";
        if (count($rows) > 0){
            $date = array();
            $multiple = array();
            $single = array();
            $drawno = array();
            $i = 0;
            $priceId = 0;
            
            foreach($rows as $row){
                $key = str_replace("-", "", $row->date_);                
                if(isset($date[$key]) == false) $date[$key] = $row->date_;
                if(isset($drawno[$key]) == false) $drawno[$key] = $row->drawno;
//                for($pp = 0; $pp < 10; $pp++){
//                    $row->result = str_replace($pp, "<div class='num'>$pp</div>", $row->result);
//                }
                if ($row->is_mpools == "N"){
                    if (isset($single[$key]) == false) $single[$key] = "";
                    $single[$key] .= "<div class='prize'><div class='header'>$row->price</div><div class='result'>$row->result</div></div>";
                }else{
                    $priceId = $row->price;
                    if(isset($multiple[$key]) == false) $multiple[$key] = array();
                    if(isset($multiple[$key][$priceId]) == false) $multiple[$key][$priceId] = "";
                    $multiple[$key][$priceId] .= "<div class='result'>$row->result</div>";
                }
            }
            
            $date = $this->sortArray($date);
            
            foreach($date as $d=>$n){
                //Generate Single results
                $tm = strtotime($n);
                $dName = $this->lang[date("D", $tm)] . date(" d/m/y", $tm);
                $result .= "<div class='result-per-day'><div class='draw-date'><div>{$this->lang['Draw Date']}: $dName</div> <div>{$this->lang['Draw No']}: $drawno[$d]</div></div><div class='clearfix'></div>";
                if (isset($single[$d])){
                    $result .= "<div class='single'>" . $single[$d] . "</div>";
                }
                if (isset($multiple[$d])){
                    $result .= "<div class='multi'>";
                    foreach($multiple[$d] as $key=>$val){
                        $result .= "<div class='prize'><div class='header'>$key</div>$val</div>" . PHP_EOL;
                    }
                    $result .= "</div>";
                }
                $result.="</div>";
            }
            $ctt = $this->paging->getPagingControl("/$dateName", $pageNumber);
            if($ctt !== "") $result .= "<div class='paging'>$ctt</div>";
        }else{
            $result .= "<div class='col-sm-12 al-center'>{$this->lang['No Result found']}!</div>";
        }
        return $result;
    }
    
    function getHomePage(){
        $pageNumber = $this->url->getSubPage(1);
        $sql = "select drawno, date_ from tbl_draw where date_ < :now order by drawno desc";
        $data = array(":now"=>date("Y-m-d H:i:s"));
        return $this->getResultBySQL($sql, $data, $pageNumber);
    }
    
    function getDrawByNo(){
        $page = $this->url->getSubPage(1);
        $result = "";
        if (strpos($page, ".html")){
            $page = str_replace(".html", "", $page);
            $n1 = explode("-", $page);
            $page = end($n1);
            if (is_numeric($page)){
                $sql = "select * from(select drawno, date_ from tbl_draw where drawno=:no limit 1) b";
                $a = $this->getResultBySQL($sql, array(":no"=>$page));
                if ($a == "") $a = "<div class='col-sm-12 al-center'>{$this->lang['No Result found']}!</div>";
                return $a;
            }
        }
        header("location: /");
    }
    
    function getResultBySQL($sql, $data, $pageNumber=1, $isParticular = false){
        $rows = $this->paging->executeQuery($sql, $data, $pageNumber, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            $as = "";
            foreach($rows as $row) $as .= "drawno=$row->drawno or ";
            $as = substr($as, 0, strlen($as)-strlen("or "));
            $sql = "select * from (
                                select a.date_, b.* from (
                                        select drawno, date_ from tbl_draw where $as
                                ) a inner join tbl_pools b on a.drawno=b.drawno
                                ) c inner join tbl_price d on c.priceid=d.priceid
                                order by c.priceid asc, c.date_, c.result desc";

            $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
        }else{ $rows = array(); }

        
        $result = "";
        if (count($rows) > 0){
            $date = array();
            $multiple = array();
            $single = array();
            $drawno = array();
            $i = 0;
            $priceId = 0;
            
            foreach($rows as $row){
                $key = str_replace("-", "", $row->date_);                
                if(isset($date[$key]) == false) $date[$key] = $row->date_;
                if(isset($drawno[$key]) == false) $drawno[$key] = $row->drawno;
                for($pp = 0; $pp < 10; $pp++){
                    $row->result = str_replace($pp, "<div class='num'>$pp</div>", $row->result);
                }
                if ($row->is_mpools == "N"){
                    if (isset($single[$key]) == false) $single[$key] = "";
                    $single[$key] .= "<div class='price'><div class='header'>$row->price</div><div class='result-wraper'>$row->result</div></div>";
                }else{
                    $priceId = $row->price;
                    if(isset($multiple[$key]) == false) $multiple[$key] = array();
                    if(isset($multiple[$key][$priceId]) == false) $multiple[$key][$priceId] = "";
                    $multiple[$key][$priceId] .= "<div class='result-wraper'>$row->result</div>";
                }
            }
            
            $date = $this->sortArray($date);
            
            foreach($date as $d=>$n){
                //Generate Single results
                $tm = strtotime($n);
                $dName = $this->lang[date("D", $tm)] . date(" d/m/y", $tm);
                $result .= "<div class='draw-date'><div class='date'>{$this->lang['Draw Date']}: <b>$dName</b></div> <div class='desc'>{$this->lang['Prize payments guaranteed in full']}</div><div class='clearfix'></div></div><hr/>";
                if (isset($single[$d])){
                    $result .= "<div class='single'>" . $single[$d] . "</div>";
                }
                if (isset($multiple[$d])){
                    foreach($multiple[$d] as $key=>$val){
                        $result .= "<div class='header'>$key</div><hr/><div class='multi'>$val</div>" . PHP_EOL;
                    }
                }
            }
            if ($i !== 0) $result.="<div class='clearfix'></div><hr/></div>";
        }else{
            $result .= "<div class='col-sm-12 al-center'>{$this->lang['No Result found']}!</div>";
        }
        return $result;
    }
            
    function getRecentdrawOptions(){
        $sql = "select drawno, date_ from tbl_draw where date_ < :now order by drawno desc";
        $rows = $this->db->executeQuery($sql, array(":now"=>date("Y-m-d") . " 00:00:01"), PDO::FETCH_OBJ);
        $result = "";
        if (count($rows) > 0){
            foreach($rows as $row){
                $dName = date("D d, F Y", strtotime($row->date_));
                $result .= "<option value='$row->date_-$row->drawno'>{$this->lang['Draw No']} $row->drawno $dName</option>";
            }
        }
        return $result;
    }
    
    function getSelectRecentdrawOptions(){
        $page = strtolower($this->url->getPage());
        if ($page == "draw"){
            $page = $this->url->getSubPage(1);
            $page = str_replace(".html", "", $page);
            return "$('#" . $this->ctrl->opSearch . "').val('$page');";
        }
        return "";
    }
            
    function sortArray($array){
        $ar = array();
        $keys = array_keys($array);
        $cnt = count($keys);
        for ($i=0; $i<$cnt; $i++){
            for($k=($i+1); $k<$cnt; $k++){
                if ($keys[$k] > $keys[$i]){
                    $big = $keys[$i];
                    $keys[$i] = $keys[$k];
                    $keys[$k] = $big;
                }
            }
        }
        
        foreach($keys as $k){
            $ar[$k] = $array[$k];
        }
        
        return $ar;
    }
    
    function getParticularDrawList($draw_type){
        $sql = "";
        if ($draw_type == gModel::fd){
            $sql = "select drawno, date_ from tbl_draw where date_ < :now and drawno in (select drawno from tbl_pools) order by date_ desc";
        }else{
            $sql = "select drawno, date_ from tbl_draw where date_ < :now and drawno in (select drawno from tbl_toto) order by date_ desc";
        }
        $rows = $this->db->executeQuery($sql, array(":now"=>date("Y-m-d")), PDO::FETCH_OBJ);
        // $result = "<select id='particularDraw' class='form-control'>";
        $result = "<select id='date' class='form-control'>";
        foreach($rows as $row){
            $tm = strtotime($row->date_);

            //$dName = $this->lang[date("D", $tm)] . date(" d, ", $tm) . $this->lang[date("F", $tm)] . date(" Y", $tm);
             $dValues = $this->lang[date("D", $tm)] . date(" d, ", $tm) . $this->lang[date("F", $tm)] . date(" Y", $tm);
            $dName =  date("d ", $tm) ."/ ". date("m", $tm) ." /". date(" Y", $tm);
            $eid = $this->ctrl->get($row->drawno);
            $result .= "<option value='$eid'>$dName</value>";
        }
        $result .= "</select>";
        return $result;
    }
    
    function getDataByParticularDraw($drawNo){
        $id = $drawNo;
        if($id == "" || $id == NULL) return $this->get4d ();
        if (is_numeric($id) == false){
            if ($this->validateDate($drawNo) == false){
                echo "Invalid Particular Draw or Date!"; return;
            }
        }
        
        $id = "%$id%";
        $sql = "select * from (select drawno, date_ from tbl_draw where (drawno like :id or cast(date_ as char(10)) like :id) and date_ < :now limit 1) a";
        $data = array(":id"=>$id, ":now"=>date("Y-m-d"));
        $rows = $this->paging->executeQuery($sql, $data, 1, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            $as = "";
            foreach($rows as $row) $as .= "drawno=$row->drawno or ";
            $as = substr($as, 0, strlen($as)-strlen("or "));
            $sql = "select * from (
                                select a.date_, b.* from (
                                        select drawno, date_ from tbl_draw where $as
                                ) a inner join tbl_pools b on a.drawno=b.drawno
                                ) c inner join tbl_price d on c.priceid=d.priceid
                                order by c.priceid asc, c.date_, c.result desc";

            $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
        }else{ $rows = array(); }

        
        $result = "";
        if (count($rows) > 0){
            $date = array();
            $multiple = array();
            $single = array();
            $drawno = array();
            $i = 0;
            $priceId = 0;
            foreach($rows as $row){
                $key = str_replace("-", "", $row->date_);                
                if(isset($date[$key]) == false) $date[$key] = $row->date_;
                if(isset($drawno[$key]) == false) $drawno[$key] = $row->drawno;
//                for($pp = 0; $pp < 10; $pp++){
//                    $row->result = str_replace($pp, "<div class='num'>$pp</div>", $row->result);
//                }
                if ($row->is_mpools == "N"){
                    if (isset($single[$key]) == false) $single[$key] = "";
                    $single[$key] .= "<div class='prize'><div class='header'>$row->price</div><div class='result'>$row->result</div></div>";
                }else{
                    $priceId = $row->price;
                    if(isset($multiple[$key]) == false) $multiple[$key] = array();
                    if(isset($multiple[$key][$priceId]) == false) $multiple[$key][$priceId] = "";
                    $multiple[$key][$priceId] .= "<div class='result'>$row->result</div>";
                }
            }
            
            $date = $this->sortArray($date);
            
            foreach($date as $d=>$n){
                //Generate Single results
                $tm = strtotime($n);
                $dName = $this->lang[date("D", $tm)] . date(" d/m/y", $tm);
                $result .= "<div class='result-per-day auto'><div class='draw-date'><div>{$this->lang['Draw Date']}: $dName</div> <div>{$this->lang['Draw No']}: $drawno[$d]</div></div><div class='clearfix'></div>";
                if (isset($single[$d])){
                    $result .= "<div class='single'>" . $single[$d] . "</div>";
                }
                if (isset($multiple[$d])){
                    $result .= "<div class='multi'>";
                    foreach($multiple[$d] as $key=>$val){
                        $result .= "<div class='prize'><div class='header'>$key</div>$val</div>" . PHP_EOL;
                    }
                    $result .= "</div>";
                }
                $result.="</div>";
            }
            
        }else{
            $result .= "<div class='col-sm-12 al-center'>{$this->lang['No Result found']}!</div>";
        }
        return $result;
    }
    
    function getWinnerShare($id){
        $a = "";
         if ($id % 2 == 0){
            $a = "<table class='table table-bordered toto1'>
                        <thead>
                            <tr>
                                <td colspan=3>Winning Shares</td>
                            </tr>
                            <tr>
                                <td>Prize Group</td><td>Share Amount</td><td>No. of Winning Shares</td>
                            </tr>
                            <tr>
                                <td>Group 1</td><td>-</td><td>-</td>
                            </tr>
                            <tr>
                                <td>Group 2</td><td>$110,628</td><td>2</td>
                            </tr>
                            <tr>
                                <td>Group 3</td><td>$2,113</td><td>72</td>
                            </tr>
                            <tr>
                                <td>Group 4</td><td>$343</td><td>242</td>
                            </tr>
                            <tr>
                                <td>Group 5</td><td>$50</td><td>4,500</td>
                            </tr>
                            <tr>
                                <td>Group 6</td><td>$25</td><td>8,281</td>
                            </tr>
                            <tr>
                                <td>Group 7</td><td>$10</td><td>83,535</td>
                            </tr>
                        </thead>
                    </table>
                    <div class='toto-ff'>Group 1 has no winner, and the prize amount of $1,050,958 will be snowballed to the next draw.</div>
                    <div class='toto-ff'>
                        Group 2 winning tickets sold at:
                        <ol>
                            <li>Singapore Pools Siglap Branch - 697B East Coast Road ( 1 QuickPick Ordinary Entry ) </li>
                            <li>Delisia Agency Pte Ltd - 149 Rochor Rd Fu Lu Shou Complex #B1-26 ( 1 Ordinary Entry ) </li>
                        </ol>
                    </div>";
        }else{
            $a = "<table class='table table-bordered toto1'>
                        <thead>
                            <tr>
                                <td colspan=3>Winning Shares</td>
                            </tr>
                            <tr>
                                <td>Prize Group</td><td>Share Amount</td><td>No. of Winning Shares</td>
                            </tr>
                            <tr>
                                <td>Group 1</td><td>$2,285,963</td><td>1</td>
                            </tr>
                            <tr>
                                <td>Group 2</td><td>$262,007</td><td>1</td>
                            </tr>
                            <tr>
                                <td>Group 3</td><td>$767</td><td>235</td>
                            </tr>
                            <tr>
                                <td>Group 4</td><td>$264</td><td>373</td>
                            </tr>
                            <tr>
                                <td>Group 5</td><td>$50</td><td>10,172</td>
                            </tr>
                            <tr>
                                <td>Group 6</td><td>$25</td><td>9,079</td>
                            </tr>
                            <tr>
                                <td>Group 7</td><td>$10</td><td>149,334</td>
                            </tr>
                        </thead>
                    </table>
                    <div class='toto-ff'>
                        Group 1 winning tickets sold at:
                        <ol>
                            <li>Kis Store - 18 Cross Street Marsh & McLennan Centre #B1-01 ( 1 System 9 Entry ) </li>
                        </ol>
                    </div>
                    <div class='toto-ff'>
                        Group 2 winning tickets sold at:
                        <ol>
                            <li>Precise Optics - 111 North Bridge Rd Peninsula Plaza #02-42 ( 1 System 7 Entry ) </li>
                        </ol>
                    </div>";
        }
        return $a;
    }
    
    function validateDate($date, $format = "Y-m-d"){
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }
    
    
    function getTimeZone(){
        $tm = date('Y-m-d H:i:s');
        $pp = date('H:i a',strtotime($tm));
        $ny = date('H:i a', strtotime($tm . ' -11hours'));
        $ld = date('H:i a', strtotime($tm . ' -6hours'));
        $zb = date('H:i a', strtotime($tm . ' -5hours'));
        $hk = date('H:i a', strtotime($tm . ' +1hours'));
        $tk = date('H:i a', strtotime($tm . ' -7hours'));
        $per = date('H:i a', strtotime($tm . ' +1hours'));
        $paris = date('H:i a', strtotime($tm . ' -5hours'));
        return 	"<li><div><div class='country'>Jakarta</div><div class='time'>$pp</div></div></li>"
				."<li><div><div class='country'>PHNOM PENH</div><div class='time'>$pp</div></div></li>"				
                . "<li class='pull-right'><div><div class='country'>New York</div><div class='time'>$ny</div></div></li>"
				."<li class='pull-right'><div><div class='country'>London</div><div class='time'>$ld</div></div></li>"
                . "<li class='hidden'><div><div class='country'>Zambia</div><div class='time'>$ny</div></div></li>"
                . "<li class='hidden'><div><div class='country'>Hongkong</div><div class='time'>$hk</div></div></li>"
                . "<li class='hidden'><div><div class='country'>Tokyo</div><div class='time'>$tk</div></div></li>"
                . "<li class='hidden'><div><div class='country'>Perth</div><div class='time'>$per</div></div></li>"
                . "<li class='hidden'><div><div class='country'>Paris</div><div class='time'>$paris</div></div></li>";
    }
    
    function getPost($title){
        
        $title = str_replace("-", " ", $title);
        $sql = "select post_description from tbl_post where cat_id=2 and post_active='T' and upper(post_title)=upper(:title) limit 1";
        $data = array(":title"=>$title);
        $rows = $this->db->executeScalare($sql, $data);
        if ($rows != null) return $rows;
        return "<div class='al-center'>No data found!</div>";
    }
    
    function getPosts($title,$limit){
        
        $title = str_replace("-", " ", $title);
        $sql = "select post_description from tbl_post where cat_id=2 and post_active='T' and upper(post_title)=upper(:title) order by post_last_update desc";
        $data = array(":title"=>$title);
        //$data = array(":title"=>$title,":lm"=>$limit);
        $rows = $this->db->executeQuery($sql, $data);
        if ($rows != null) return $rows;
        return "<div class='al-center'>No data found!</div>";
    }
    function getNews(){
        $sql = "select post_title from tbl_category c inner join tbl_post p On c.cat_id = p.cat_id where cat_name = 'News' and post_active='T' order by post_last_update desc limit 10";
        //$data = array(":title"=>$title,":lm"=>$limit);
        $rows = $this->db->executeQuery($sql);
        if ($rows != null) return $rows;
        return "<div class='al-center'>No data found!</div>";        
    }
    function getTopNews(){
       $rows = $this->getNews();
       $result ="<ul class='news'>";
       $i = 0;
       foreach($rows as $row){
           $t = $row['post_title'];
           $result .= "<li class='arrow'><a href='/news?s=$t'>$t</a></li>";     
           if($i==3) break;
           $i+=1;
       }
       return $result .= "</ul>"; 
    }
    function searchNews($title){
        $sql = "Select post_description from  tbl_category c inner join tbl_post p on c.cat_id = p.cat_id where cat_name = 'News' and upper(post_title) = upper(:param) and post_active='T'";
        $result = "<p class='title' style='font-weight:bold;margin-bottom:10px;'>" . $title . "</p>";
        $data = array(":param"=>$title);
        $row = $this->db->executeScalare($sql,$data);
        if(count($row)>=0){
            $result .=  $row ;   
        }
        return $result;    
    }
}
?>