<?php
    
    if (!class_exists("MAIL")){
        class MAIL{
            private $to;
            private $from;
            private $cc;
            private $bcc;
            private $subject;
            private $body;
            private $attachment;
            private $attachment_count = 0;
            
            private $mail_separator = ",";

            public function __construct(){
                $server = new SERVER();
                $this->to = "";
                $a = $server->get(SERVER::SERVER_NAME);
                $a = str_replace("www.", "", $a);
                $this->from = "no-reply@" . $a;
                $this->cc = "";
                $this->bcc = "";
                $this->subject = "";
                $this->body = "";
                $this->attachment = array();
                unset($server);
            }
            
            /**
             * Field recipients are the audience of the message
             * @param String $mail_address
             */
            public function addTo($mail_address){
                $this->to .= $this->cleanMail($mail_address) . $this->mail_separator;
            }
            
            /**
             * Field recipients are those being discreetly or surreptitiously informed of the communication and cannot be seen by any of the other addressees.
             * @param String $mail_address
             */
            public function addBcc($mail_address){
                $this->bcc .= $this->cleanMail($mail_address) . $this->mail_separator;
            }
            
            /**
             * Field recipients are others whom the author wishes to publicly inform of the message (carbon copy)
             * @param String $mail_address
             */
            public function addCc($mail_address){
                $this->cc .= $this->cleanMail($mail_address) . $this->mail_separator;
            }
            
            /**
             * Set which E-mail address that you are going to use as mail header
             * @param String $mail_address
             */
            public function setFrom($mail_address){
                $a = $this->cleanMail($mail_address);
                
                //From email address cannot have 2 mails
                if (strpos($a, $this->mail_separator) !== FALSE){
                    $b = explode($this->mail_separator, $a);
                    $this->from = $b;
                    unset($b);
                }else{
                    $this->from = $a;
                }
                unset($a);
            }
            
            /**
             * Set Path of file or file controls name which you want to attach to your mail
             * @param String $pathOfFile exact path of file / Controls name
             * @param String $name the name of file or NULL if you want to send default name
             */
            public function attach($pathOfFile, $name = NULL){
                $this->attachment[$this->attachment_count][0] = $pathOfFile;
                $this->attachment[$this->attachment_count][1] = $name;
                $this->attachment_count += 1;
            }

            /**
             * Set subject of your mail
             * @param String $subject
             */
            public function setSubject($subject){
                $this->subject = $subject;
            }
            
            /**
             * Set body of your mail
             * @param String $body
             */
            public function setBody($body){
                $this->body = $body;
            }

            /**
             * Start send mail
             */
            public function send(){
                $attachment = "";
                // boundary 
                $semi_rand = md5(time()); 
                $mime_boundary = "==Multipart_Boundary_x{$semi_rand}x";
                
                $attachment = "";
                foreach($this->attachment as $key=>$val){
                    $filePath = $val[0];
                    $fileName = $val[1];
                    if ($fileName === NULL) {
                        $fileName = basename($filePath);
                    }
                    
                    if(file_exists($filePath)){
                        $handle = fopen($filePath,"rb");
                        rewind($handle);
                        $size = filesize($filePath);
                        $data = fread($handle, $size);
                        fclose($handle);
                        $data = chunk_split(base64_encode($data));
                        $b = array();
                        $b[] = "Content-Type:  \"" . "application/octet-stream" . "\"";
                        $b[] = "Content-Transfer-Encoding: base64";
                        $b[] = "Content-Disposition: attachment; filename=\"$fileName\"";
                        $attachment .= implode("\r\n", $b);
                        $attachment .= "\r\n\r\n" . $data . "\r\n\r\n";
                        $attachment .= "--{$mime_boundary}\r\n";
                        unset ($b);
                    }
                }
                
                $to1 = substr($this->to, 0, strlen($this->to) - strlen($this->mail_separator));
                $header = "From: " . $this->from . "\r\n";
                //$header .= "To: " . $to1 . "\r\n";
                if ($this->cc !== ""){ 
                    $to = substr($this->cc, 0, strlen($this->cc) - strlen($this->mail_separator));
                    $header .= "Cc: " . $to . "\r\n"; 
                }
                if ($this->bcc !== ""){ 
                    $to = substr($this->bcc, 0, strlen($this->bcc) - strlen($this->mail_separator));
                    $header .= "Bcc: " . $to . "\r\n";
                }
                
                //unset($to);
                if ($attachment !== ""){ 
                    $header .= "Content-Type: multipart/mixed;\r\n boundary=\"{$mime_boundary}\"\r\n";
                    // multipart boundary 
                    $message = "This is a multi-part message in MIME format.\r\n\r\n" . "--{$mime_boundary}\r\nMIME-Version: 1.0\r\nContent-Type: text/html; charset=ISO-8859-1\r\nContent-Transfer-Encoding: 7bit\r\n\r\n" . $this->body . "\r\n\r\n"; 
                    $message .= "--{$mime_boundary}\r\n";
                    $message .= $attachment;
                }else{ 
                    $header .= "Content-Type: text/html;\r\n boundary=\"{$mime_boundary}\"\r\n";
                    $message = $this->body;
                }
//                echo "<br/>Header:<br/> $header<br/>TO: $to1<br/>";
//                echo "Message:<br/>" . str_replace("\r\n", "<br/>", $message);
                
                return mail($to1, $this->subject, $message, $header, "-f -r $this->from");
            }
            
            private function cleanMail($string_mail){
                $string_mail = trim(strtolower($string_mail));
                
                $param = array(":", "cc", "bcc", "to", "from", "subject", "body", "reply-to");
                foreach ($param as $p){
                    $string_mail = str_replace($p, "", $string_mail);
                }
                while(strpos($string_mail, "  ") !== FALSE) $string_mail = str_replace ("  ", " ", $string_mail);
                
                //replace blacklist character
                $param = array(";", ",");
                foreach ($param as $val){
                    $string_mail = str_replace($val, $this->mail_separator, $string_mail);
                }
                
                //replace duplicated seperators
                $val1 = $this->mail_separator . $this->mail_separator;
                while(strpos($string_mail, $val1) !== FALSE) $string_mail = str_replace ($val1, $this->mail_separator, $string_mail);
                
                return $string_mail;
            }
            
            private function getMime_type($file){
                $exk = "dara_exception_extension";
                if (strpos($file, ".") !== FALSE){
                    $a = explode(".", $file);
                    $key = end($a);
                }else{
                    $key = $exk;
                }
                $key = strtolower($key);
                
                if (key_exists($key, $this->mime_type)) return $this->mime_type[$key];
                else if ($key == $exk){
                    return "text/plain";
                }else{
                    return "application/octet-stream";
                }
                
            }


            private $mime_type = array('evy' => 'application/envoy',
                                        'fif' => 'application/fractals',
                                        'spl' => 'application/futuresplash',
                                        'hta' => 'application/hta',
                                        'acx' => 'application/internet-property-stream',
                                        'hqx' => 'application/mac-binhex40',
                                        'doc' => 'application/msword',
                                        'dot' => 'application/msword',
                                        '*' => 'application/octet-stream',
                                        'bin' => 'application/octet-stream',
                                        'class' => 'application/octet-stream',
                                        'dms' => 'application/octet-stream',
                                        'exe' => 'application/octet-stream',
                                        'lha' => 'application/octet-stream',
                                        'lzh' => 'application/octet-stream',
                                        'oda' => 'application/oda',
                                        'axs' => 'application/olescript',
                                        'pdf' => 'application/pdf',
                                        'prf' => 'application/pics-rules',
                                        'p10' => 'application/pkcs10',
                                        'crl' => 'application/pkix-crl',
                                        'ai' => 'application/postscript',
                                        'eps' => 'application/postscript',
                                        'ps' => 'application/postscript',
                                        'rtf' => 'application/rtf',
                                        'setpay' => 'application/set-payment-initiation',
                                        'setreg' => 'application/set-registration-initiation',
                                        'xla' => 'application/vnd.ms-excel',
                                        'xlc' => 'application/vnd.ms-excel',
                                        'xlm' => 'application/vnd.ms-excel',
                                        'xls' => 'application/vnd.ms-excel',
                                        'xlt' => 'application/vnd.ms-excel',
                                        'xlw' => 'application/vnd.ms-excel',
                                        'msg' => 'application/vnd.ms-outlook',
                                        'sst' => 'application/vnd.ms-pkicertstore',
                                        'cat' => 'application/vnd.ms-pkiseccat',
                                        'stl' => 'application/vnd.ms-pkistl',
                                        'pot' => 'application/vnd.ms-powerpoint',
                                        'pps' => 'application/vnd.ms-powerpoint',
                                        'ppt' => 'application/vnd.ms-powerpoint',
                                        'mpp' => 'application/vnd.ms-project',
                                        'wcm' => 'application/vnd.ms-works',
                                        'wdb' => 'application/vnd.ms-works',
                                        'wks' => 'application/vnd.ms-works',
                                        'wps' => 'application/vnd.ms-works',
                                        'hlp' => 'application/winhlp',
                                        'bcpio' => 'application/x-bcpio',
                                        'cdf' => 'application/x-cdf',
                                        'z' => 'application/x-compress',
                                        'tgz' => 'application/x-compressed',
                                        'cpio' => 'application/x-cpio',
                                        'csh' => 'application/x-csh',
                                        'dcr' => 'application/x-director',
                                        'dir' => 'application/x-director',
                                        'dxr' => 'application/x-director',
                                        'dvi' => 'application/x-dvi',
                                        'gtar' => 'application/x-gtar',
                                        'gz' => 'application/x-gzip',
                                        'hdf' => 'application/x-hdf',
                                        'ins' => 'application/x-internet-signup',
                                        'isp' => 'application/x-internet-signup',
                                        'iii' => 'application/x-iphone',
                                        'js' => 'application/x-javascript',
                                        'latex' => 'application/x-latex',
                                        'mdb' => 'application/x-msaccess',
                                        'crd' => 'application/x-mscardfile',
                                        'clp' => 'application/x-msclip',
                                        'dll' => 'application/x-msdownload',
                                        'm13' => 'application/x-msmediaview',
                                        'm14' => 'application/x-msmediaview',
                                        'mvb' => 'application/x-msmediaview',
                                        'wmf' => 'application/x-msmetafile',
                                        'mny' => 'application/x-msmoney',
                                        'pub' => 'application/x-mspublisher',
                                        'scd' => 'application/x-msschedule',
                                        'trm' => 'application/x-msterminal',
                                        'wri' => 'application/x-mswrite',
                                        'cdf' => 'application/x-netcdf',
                                        'nc' => 'application/x-netcdf',
                                        'pma' => 'application/x-perfmon',
                                        'pmc' => 'application/x-perfmon',
                                        'pml' => 'application/x-perfmon',
                                        'pmr' => 'application/x-perfmon',
                                        'pmw' => 'application/x-perfmon',
                                        'p12' => 'application/x-pkcs12',
                                        'pfx' => 'application/x-pkcs12',
                                        'p7b' => 'application/x-pkcs7-certificates',
                                        'spc' => 'application/x-pkcs7-certificates',
                                        'p7r' => 'application/x-pkcs7-certreqresp',
                                        'p7c' => 'application/x-pkcs7-mime',
                                        'p7m' => 'application/x-pkcs7-mime',
                                        'p7s' => 'application/x-pkcs7-signature',
                                        'sh' => 'application/x-sh',
                                        'shar' => 'application/x-shar',
                                        'swf' => 'application/x-shockwave-flash',
                                        'sit' => 'application/x-stuffit',
                                        'sv4cpio' => 'application/x-sv4cpio',
                                        'sv4crc' => 'application/x-sv4crc',
                                        'tar' => 'application/x-tar',
                                        'tcl' => 'application/x-tcl',
                                        'tex' => 'application/x-tex',
                                        'texi' => 'application/x-texinfo',
                                        'texinfo' => 'application/x-texinfo',
                                        'roff' => 'application/x-troff',
                                        't' => 'application/x-troff',
                                        'tr' => 'application/x-troff',
                                        'man' => 'application/x-troff-man',
                                        'me' => 'application/x-troff-me',
                                        'ms' => 'application/x-troff-ms',
                                        'ustar' => 'application/x-ustar',
                                        'src' => 'application/x-wais-source',
                                        'cer' => 'application/x-x509-ca-cert',
                                        'crt' => 'application/x-x509-ca-cert',
                                        'der' => 'application/x-x509-ca-cert',
                                        'pko' => 'application/ynd.ms-pkipko',
                                        'zip' => 'application/zip',
                                        'au' => 'audio/basic',
                                        'snd' => 'audio/basic',
                                        'mid' => 'audio/mid',
                                        'rmi' => 'audio/mid',
                                        'mp3' => 'audio/mpeg',
                                        'aif' => 'audio/x-aiff',
                                        'aifc' => 'audio/x-aiff',
                                        'aiff' => 'audio/x-aiff',
                                        'm3u' => 'audio/x-mpegurl',
                                        'ra' => 'audio/x-pn-realaudio',
                                        'ram' => 'audio/x-pn-realaudio',
                                        'wav' => 'audio/x-wav',
                                        'bmp' => 'image/bmp',
                                        'cod' => 'image/cis-cod',
                                        'gif' => 'image/gif',
                                        'ief' => 'image/ief',
                                        'jpe' => 'image/jpeg',
                                        'jpeg' => 'image/jpeg',
                                        'jpg' => 'image/jpeg',
                                        'jfif' => 'image/pipeg',
                                        'svg' => 'image/svg+xml',
                                        'tif' => 'image/tiff',
                                        'tiff' => 'image/tiff',
                                        'ras' => 'image/x-cmu-raster',
                                        'cmx' => 'image/x-cmx',
                                        'ico' => 'image/x-icon',
                                        'pnm' => 'image/x-portable-anymap',
                                        'pbm' => 'image/x-portable-bitmap',
                                        'pgm' => 'image/x-portable-graymap',
                                        'ppm' => 'image/x-portable-pixmap',
                                        'rgb' => 'image/x-rgb',
                                        'xbm' => 'image/x-xbitmap',
                                        'xpm' => 'image/x-xpixmap',
                                        'xwd' => 'image/x-xwindowdump',
                                        'mht' => 'message/rfc822',
                                        'mhtml' => 'message/rfc822',
                                        'nws' => 'message/rfc822',
                                        'css' => 'text/css',
                                        '323' => 'text/h323',
                                        'htm' => 'text/html',
                                        'html' => 'text/html',
                                        'stm' => 'text/html',
                                        'uls' => 'text/iuls',
                                        'bas' => 'text/plain',
                                        'c' => 'text/plain',
                                        'h' => 'text/plain',
                                        'txt' => 'text/plain',
                                        'php' => 'text/plain',
                                        'rtx' => 'text/richtext',
                                        'sct' => 'text/scriptlet',
                                        'tsv' => 'text/tab-separated-values',
                                        'htt' => 'text/webviewhtml',
                                        'htc' => 'text/x-component',
                                        'etx' => 'text/x-setext',
                                        'vcf' => 'text/x-vcard',
                                        'mp2' => 'video/mpeg',
                                        'mpa' => 'video/mpeg',
                                        'mpe' => 'video/mpeg',
                                        'mpeg' => 'video/mpeg',
                                        'mpg' => 'video/mpeg',
                                        'mpv2' => 'video/mpeg',
                                        'mov' => 'video/quicktime',
                                        'qt' => 'video/quicktime',
                                        'lsf' => 'video/x-la-asf',
                                        'lsx' => 'video/x-la-asf',
                                        'asf' => 'video/x-ms-asf',
                                        'asr' => 'video/x-ms-asf',
                                        'asx' => 'video/x-ms-asf',
                                        'avi' => 'video/x-msvideo',
                                        'movie' => 'video/x-sgi-movie',
                                        'flr' => 'x-world/x-vrml',
                                        'vrml' => 'x-world/x-vrml',
                                        'wrl' => 'x-world/x-vrml',
                                        'wrz' => 'x-world/x-vrml',
                                        'xaf' => 'x-world/x-vrml',
                                        'xof' => 'x-world/x-vrml',
                                        );
        }
    }
?>