<?php
include_once dirname(__DIR__).'/Session/SESSION.php';
include_once dirname(__DIR__).'/Url/URL.php';
include_once dirname(__DIR__).'/Model/MODEL.php';
include_once dirname(__DIR__).'/View/VIEW.php';

if (!class_exists("CONTROLLER")){
    class CONTROLLER{
        private $websitePath;
        private $controller;
        public $defaultPage;
        private $session;
        private $url;
        
        public function __construct($controllerMainPath, $skipUrlIndexCount = 0)
        {
            $this->websitePath = $controllerMainPath;
            $this->session = new SESSION();
            $this->url = new URL($skipUrlIndexCount);
        }
        
        /**
         * get : use to execute controller in controller dirctory on website path
         * @param string $name represent the controller name
         * @return controller syntax
         */ 
        public function get($name){
            try{
                $name  = trim(strtolower($name));
                if ($name == '') $name = 'index';

                if ($this->isStartWithNumber($name)) $name = '_'.$name;

                $class = $name."Controller";
                if (!isset($this->controller[$name])){
                    if (file_exists($this->websitePath . $class . ".php"))
                    {
                        include_once $this->websitePath . $class . ".php";

                        if (class_exists($class))
                        {
                            $this->controller[$name] = new $class();
                            $this->controller[$name]->controller = &$this->session->{DATA::controllerString};
                            $this->controller[$name]->view = &$this->session->{DATA::viewString};
                            $this->controller[$name]->model = &$this->session->{DATA::modelString};
                            $this->controller[$name]->ctrl = &$this->session->{DATA::ctrlString};
                            
                            $this->controller[$name]->url = &$this->url;
                            $this->controller[$name]->session = &$this->session;
                            
                            if (method_exists($this->controller[$name], 'init'))
                            {
                                $this->controller[$name]->init();
                            }
                        }
                        else
                        {
                            $this->controller[$name] = $this->getPage($this->websitePath . $this->defaultPage . ".php", $this->defaultPage.'Controller');
                        }
                    }
                    else
                    {
                        $class = $this->defaultPage.'Controller';
                        $this->controller[$name] = $this->getPage($this->websitePath . $class . ".php", $class);
                        
                        if ($this->controller[$name] == null) echo "Page Not Found!";
                    }
                }

                    return $this->controller[$name];
            }  catch (Exception $e){
                return null;
            }
        }
        
        private function getPage($path, $class){
            try{
                $c = null;
                if (file_exists($path))
                {
                    include_once $path;

                    if (class_exists($class))
                    {
                        $c = new $class();
                        $c->controller = &$this->session->{DATA::controllerString};
                        $c->view = &$this->session->{DATA::viewString};
                        $c->model = &$this->session->{DATA::modelString};
                        $c->ctrl = &$this->session->{DATA::ctrlString};

                        $c->url = &$this->url;
                        $c->session = &$this->session;

                        if (method_exists($c, 'init'))
                        {
                            $c->init();
                        }
                    }
                    else
                    {
                        return null;
                    }
                }
                return $c;
            } catch (Exception $e) {
                return null;
            }
        }
        
        private function isStartWithNumber($str){
            $a = substr($str, 0, 1);
            $ret = false;
            switch ($a){
                case '1':
                case '2':        
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case '0':
                    $ret = true;
            }
            return $ret;
        }
        
        public function __get($name)
        {
            return $this->get($name);
        }
    }
}
?>