<?php $data = $model->ipfilter->isEnabledIPfilter(); ?>
<div class="panel panel-default left">
    <div class="panel-heading" id="panel-header">
        <b>Add New IP Address</b>
    </div>
    <div class="panel-body">
        
            <input type="checkbox" id="<?php echo $ctrl->chk; ?>" <?php echo ($data["status"] == "0" ? "" : "checked"); ?> />
            <label for="<?php echo $ctrl->chk; ?>"> Enable IP Filter</label>
            <br/>
            <label>
                <input type="radio" id="<?php echo $ctrl->rEnable; ?>" name="<?php echo $ctrl->radio; ?>"/> <span class="require">Enable</span> the following IP address
            </label><br/>
            <label>
                <input type="radio" id="<?php echo $ctrl->rDisable; ?>" name="<?php echo $ctrl->radio; ?>"/> <span class="require">Disable</span> the following IP address
            </label>
    
            <form method="POST" id="<?php echo $ctrl->frm1; ?>" class="form-horizontal">
                <input type="hidden" id="<?php echo $ctrl->hd; ?>" name="<?php echo $ctrl->hd; ?>" />
                <div class="form-group row">
                    <label for="<?php echo $ctrl->ip; ?>" class="col-sm-4 control-label"><b>IP Address <span class="require">*</span></b></label>
                    <div class="col-sm-8">
                        <input type="text" class="form-control" name="<?php echo $ctrl->ip; ?>" id="<?php echo $ctrl->ip; ?>" />
                    </div>
                </div>
                <div class="form-group row">
                    <label for="<?php echo $ctrl->desc; ?>" class="col-sm-4 control-label"><b>Description</b></label>
                    <div class="col-sm-8">
                        <textarea id="<?php echo $ctrl->desc; ?>" class="form-control" style="width: 100%; height: 100px;"></textarea>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="<?php echo $ctrl->status; ?>" class="col-sm-4 control-label"><b>Status <span class="require">*</span></b></label>
                    <div class="col-sm-8">
                        <input type="hidden" name="<?php echo $ctrl->status; ?>" id="<?php echo $ctrl->status; ?>" value="<?php echo $ctrl->get("1"); ?>" />
                        <h3 class="nomargin"><span id="<?php echo $ctrl->estatus; ?>" class="point label label-primary">Enable</span></h3>
                    </div>
                </div>

                <div class="form-group row">
                    <div class="col-sm-4">
                    </div>
                    <div class="col-sm-8 al-left">
                        <div class="al-right">
                            <span class="require">*</span> Required field
                        </div><br/>
                        <button type="button" id="<?php echo $ctrl->save1; ?>" class="btn btn-default">Save</button>
                        <button type="button" id="<?php echo $ctrl->btnReset; ?>" class="btn btn-default">Reset</button>
                    </div>
                </div>
        </form>
    </div>
</div>
<div class="panel panel-default right">
    <div class="panel-heading">
        <b>Time Filter</b>
    </div>
    <div class="panel-body">
        <table class="table">
                <thead>
                    <tr>
                        <th class="col-sm-3">IP Address</th>
                        <th class="col-sm-3">Description</th>
                        <th style="width: 15%;">Status</th>
                    </tr>
                </thead>
                <tbody id='<?php echo $ctrl->main; ?>'>
                      <?php 
                    $model->ipfilter->getIpAddress($url->getSubPage(2));
                ?>
                </tbody>
            </table>
    </div>
</div>

<script>
    $(document).ready(function (){
        
        $("#<?php echo $ctrl->ip; ?>").select();
        $("#<?php echo ($data["isEnable"] == "1" ? $ctrl->rEnable : $ctrl->rDisable); ?>").prop("checked", true);
        
        $("#<?php echo $ctrl->rEnable; ?>").on("change", function (){<?php echo $ctrl->fnEnable; ?>();});
        $("#<?php echo $ctrl->rDisable; ?>").on("change", function (){<?php echo $ctrl->fnEnable; ?>();});
        $('#<?php echo $ctrl->chk; ?>').on('change', function (){
            $('#blanket').css('display', 'table');
            var a = ($('#<?php echo $ctrl->chk; ?>').prop('checked') ? '1' : '0');
            var <?php echo $ctrl->url;?> = '/process/ipfilter.aspx?token=<?php echo $ctrl->status; ?>&s=' + a;
            $.ajax({url: <?php echo $ctrl->url;?>}).done(function (msg){
                $('#blanket').css('display', 'none');
                if (msg === '0'){
                    a = $('#<?php echo $ctrl->chk; ?>').prop('checked');
                    if (a === true) $('#<?php echo $ctrl->chk; ?>').prop('checked', false);
                    else $('#<?php echo $ctrl->chk; ?>').prop('checked', true);
                }
            });
        });
        $("#<?php echo $ctrl->btnReset; ?>").on("click", reset);
        
        $("#<?php echo $ctrl->ip; ?>").keypress(function (e){
            $(this).attr("title", "");
            $(this).tooltip("destroy");

            var c = e.keyCode || e.keyChar || e.which;
            if ((c > 47 && c < 58) || c === 46 || c === 8 || c === 9){
                if ($(this).val().length > 15){
                    $(this).attr("title", "IP Address is in format: xxx.xxx.xxx.xxx");
                    $(this).tooltip("show");
                    return false;
                }
                return true;
            }
            $(this).attr("title", "Only numberic and period sign (.) are allowed!");
            $(this).tooltip("show");
            return false;
        });
        $("#<?php echo $ctrl->estatus; ?>").click(function (){
            <?php echo $ctrl->changeTextStatus; ?>($(this));
            if ($(this).html().indexOf("Enable") !== -1){ 
                $("#<?php echo $ctrl->status; ?>").val("<?php echo $ctrl->get("1"); ?>");
            }else{
                $("#<?php echo $ctrl->status; ?>").val("<?php echo $ctrl->get("0"); ?>");
            }
        });
        $("#<?php echo $ctrl->save1; ?>").click(<?php echo $ctrl->fnSave ?>);
        
        
        function <?php echo $ctrl->fnEnable; ?>(){
            $("#blanket").css("display", "table");
            var a = ($("#<?php echo $ctrl->rEnable; ?>").prop("checked") === true ? '<?php echo $ctrl->get("1") ?>' : '<?php echo $ctrl->get("0") ?>');
            var <?php echo $ctrl->url ?> = "/process/ipfilter.aspx?token=<?php echo $ctrl->enable; ?>&s=" + a;
            $.ajax({url: <?php echo $ctrl->url ?>}).done(function (msg){
                $("#blanket").css("display", "none");
                if (msg === "0"){
                    a = $("#<?php echo $ctrl->rEnable; ?>").prop("checked");
                    if (a === true) $("#<?php echo $ctrl->rEnable; ?>").prop("checked", false);
                    else $("#<?php echo $ctrl->rEnable; ?>").prop("checked", true);
                }
            });
        }
        
        function <?php echo $ctrl->fnSave ?>(){
            $('#blanket').css('display', 'table');
            $("#<?php echo $ctrl->ip; ?>").attr("title", "");
            $("#<?php echo $ctrl->ip; ?>").tooltip("destroy");
            
            $("#<?php echo $ctrl->status; ?>").attr("title", "");
            $("#<?php echo $ctrl->status; ?>").tooltip("destroy");
            
            var <?php echo $ctrl->ip; ?> = $("#<?php echo $ctrl->ip; ?>").val().trim();

            var a = false;
            if(<?php echo $ctrl->ip; ?> === ""){
                $("#<?php echo $ctrl->ip; ?>").attr("title", "IP Address is required!");
                $("#<?php echo $ctrl->ip; ?>").tooltip("show");
                a = true;
            }else{
                var cccc =  <?php echo $ctrl->ip; ?>.split('.');
                if (cccc.length < 4 || cccc.length > 4){
                    $("#<?php echo $ctrl->ip; ?>").attr("title", "IP Address is in format: xxx.xxx.xxx.xxx");
                    $("#<?php echo $ctrl->ip; ?>").tooltip("show");
                    a = true;
                }
                for(var i = 0; i < 3; i++){
                    if (parseInt(cccc[i]) > 255){
                        $("#<?php echo $ctrl->ip; ?>").attr("title", "IP Address must be in range 0 to 255 only!");
                        $("#<?php echo $ctrl->ip; ?>").tooltip("show");
                        a = true;
                        break;
                    }else if (cccc[i].length > 3){
                        $("#<?php echo $ctrl->ip; ?>").attr("title", "IP Address is in format: xxx.xxx.xxx.xxx");
                        $("#<?php echo $ctrl->ip; ?>").tooltip("show");
                        a = true;
                    }
                }
            }
            
            if (a === true){
                $('#blanket').css('display', 'none');
                return;
            }
            
            
            var u = ($("#<?php echo $ctrl->save1; ?>").html() === "Save" ? "<?php echo $ctrl->add; ?>" : "<?php echo $ctrl->edit; ?>");
            
            $.ajax({
                url: "/process/ipfilter.aspx?token=" + u,
                type: 'POST',
                data: {
                    <?php echo $ctrl->eip; ?> : $("#<?php echo $ctrl->hd; ?>").val(),
                    <?php echo $ctrl->ip; ?> : $("#<?php echo $ctrl->ip; ?>").val(),
                    <?php echo $ctrl->status; ?> : $("#<?php echo $ctrl->status; ?>").val(),
                    <?php echo $ctrl->desc; ?> : $("#<?php echo $ctrl->desc; ?>").val()
                }
            }).done(function (msg){
                var body = "";
                var header = "";
                   if (msg === "1"){
                       header = "Success";
                       body = "Process is ready, thanks!";
                       reset();
                       <?php echo $ctrl->fnQuery; ?>();
                   }else{
                       if (msg === "0") msg = "There were some error while we are trying to process your request!";
                       header = "Error";
                       body = msg;
                   }
                    $('#myModalLabel').html(header);
                    $('#modelbody').html(body);
                    $('#btnmclose').html('Close');
                    $('#btnmok').hide();
                    $('#myModal').modal({show: true});
                    $('#blanket').css('display', 'none');
            });
        }
        
        function reset(){
            $("#<?php echo $ctrl->ip; ?>").attr("title", "");
            $("#<?php echo $ctrl->ip; ?>").tooltip("destroy");
            $("#<?php echo $ctrl->status; ?>").attr("title", "");
            $("#<?php echo $ctrl->status; ?>").tooltip("destroy");
            $("#<?php echo $ctrl->frm1; ?>").resetForm();
            $('#panel-header').html('<b>Add New IP Address</b>');
            
            $("#<?php echo $ctrl->btnReset; ?>").html("Reset");
            $("#<?php echo $ctrl->save1; ?>").html("Save");
            $("#<?php echo $ctrl->ip; ?>").select();
        }
    });
    
    function <?php echo $ctrl->fnQuery; ?>(){
        $('#blanket').css('display', 'table');
        var u = '/ajax.htm/<?php echo $url->getSubPage(2); ?>?page=ipfilter&token=<?php echo $ctrl->get; ?>';
        $.ajax({url: u}).done(function (msg){
            $("#<?php echo $ctrl->main; ?>").html(msg);
            $('#blanket').css('display', 'none');
        });
    }
    
    function <?php echo $ctrl->changeStatus; ?>(id){
        var a = $("#" + id).parent().parent();
        var b = a.find("span.chgStatus");
        <?php echo $ctrl->changeTextStatus; ?>(b);
    }
    
    function <?php echo $ctrl->changeTextStatus; ?>(control){
        var c = control.html();
        if (c === "Enable"){
            control.html("Disable");
            if (control.hasClass("label-primary")) control.removeClass("label-primary");
            control.addClass("label-default");
        }else{
            control.html("Enable");
            if (control.hasClass("label-default")) control.removeClass("label-default");
            control.addClass("label-primary");
        }
    }
</script>