<?php

class userModel {
    private $db;
    private $paging;
            
    function init(){
        $this->db = new DATABASE(DB_HOST, DB_NAME, DB_USER, DB_PASS);
        $this->paging = new PAGING(DB_HOST, DB_NAME, DB_USER, DB_PASS, 15);
    }
    
    function getUsers($page = 1){
        if (is_numeric($page) == FALSE || $page < 1) $page = 1;
        $sql = "select * from tbl_user";
        $rows = $this->paging->executeQuery($sql, array(), $page, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            foreach($rows as $row){
                $active = ($row->active == "T" ? "Yes" : "No");
                $ct = '<span class="edit glyphicon glyphicon-pencil point" title="" data-original-title="Edit"></span>';
                $eid = $this->ctrl->get($row->userid);
                echo "<tr id='$eid'><td>{$row->username}</td><td>{$row->display}</td><td>{$row->email}</td><td>{$active}</td><td class='al-center'>$ct</td></tr>" . PHP_EOL;
            }
            $ct = $this->paging->getPagingControl("/user.aspx", $page);
            if ($ct !== ""){
                echo "<tr><td colspan='5' class='al-right'>$ct</td></tr>";
            }
        }
        echo "<script>
            $('.edit').click(function(){
                $('#blanket').css('display', 'table');
                    var a = $(this).parent().parent().attr('id');
                    var u = '/ajax.htm/' + a + '?page=user&token=" . $this->ctrl->edit . "';
                    $('#" . $this->ctrl->hd . "').val(a);
                    $.ajax({url:u}).done(function(msg){
                        if (msg !== '0'){
                            var b = msg.split('[dara_spliter]');
                            if (b.length > 1){
                                $('#" . $this->ctrl->user . "').val(b[0]);
                                $('#" . $this->ctrl->display . "').val(b[1]);
                                $('#" . $this->ctrl->mail . "').val(b[2]);
                                if (b[3] === 'F') $('#" . $this->ctrl->active . "').removeAttr('checked');
                                $('#" . $this->ctrl->role . "').val(b[4]);
                                    
                                $('#" . $this->ctrl->btnOk . "').val('Update');
                                $('#" . $this->ctrl->btnReset . "').val('Cancel');
                                $('#" . $this->ctrl->pwd . "').attr('placeholder', 'Leave this file blank if you don\'t want to change password');
                                $('#" . $this->ctrl->cpwd . "').attr('placeholder', 'Leave this file blank if you don\'t want to change password');
                                $('#process-header').html('<b>Edit User</b>');
                            }
                        }
                        $('#blanket').css('display', 'none');
                    });
            });
        </script>";
    }
    
    function doAddUser(){
        $user = $this->ctrl->user->getText();
        $display = $this->ctrl->display->getText();
        $mail = $this->ctrl->mail->getText();
        $pwd = $this->ctrl->pwd->getText();
        $cpwd = $this->ctrl->cpwd->getText();
        $role = $this->ctrl->role->getDText();
        $active = ($this->ctrl->active->getText() == NULL ? "F" : "T");
        
        $error = "";
        if($user == ""){
            $error .= "<li>User Name cannot be empty!</li>";
        }
        if ($display == ""){
            $error .= "<li>Display Name cannot be empty!</li>";
        }
        if ($mail == ""){
            $error .= "<li>E-mail address cannot be empty!</li>";
        }
        if ($pwd == ""){
            $error .= "<li>Password cannot be empty!</li>";
        }
        if (is_numeric($role) === false){
            $error .= "<li>Invalid role selected!</li>";
        }
        if ($active == "" || $active == NULL){
            $error .= "<li>Invalid active status!</li>";
        }
        if ($error !== ""){
            echo "You have some errors:<br/><ul>$error</ul>";
            return;
        }
        
        if (strpos($mail, ".") == FALSE || strpos($mail,"@") == FALSE){
            $error .= "<li>Invalid E-mail address!</li>";
        }
        if ($pwd !== $pwd){
            $error .= "<li>Password and Confirm password must be the same!</li>";
        }
        if ($error !== ""){
            echo "You have some errors:<br/><ul>$error</ul>";
            return;
        }
        
        $sql = "insert into tbl_user (username, password, display, email, active, role) 
                values(:user, :pwd, :display, :mail, :active, :role)";
        $data = array(":user"=>$user, ":pwd"=>$this->model->login->enc($pwd), ":display"=>$display, 
                      ":mail"=>$mail, ":active"=>$active, ":role"=>$role);
        $a = $this->db->executeUpdate($sql, $data);
        if ($a > 0) $this->model->login->log("Add new user");
        echo $a;
    }
    
    function getEditUser($eid){
        $eid = $this->ctrl->getName($eid);
        if (is_numeric($eid) === FALSE){
            echo "0";
            return;
        }
        
        $sql = "select * from tbl_user where userid=:id limit 1";
        $data = array(":id"=>$eid);
        $row = $this->db->executeQuery($sql, $data, PDO::FETCH_OBJ);
        if (count($row) > 0){
            $row = $row[0];
            $separater = "[dara_spliter]";
            echo $row->username . $separater . $row->display . $separater . $row->email . $separater . $row->active . $separater . $this->ctrl->get($row->role);
            return;
        }
        echo "0";
    }
    
    function doEditUser(){
        $id = $this->ctrl->hd->getDText();
        if (is_numeric($id) === FALSE){
            echo "Invalid User id!";
            return;
        }
        
        $user = $this->ctrl->user->getText();
        $display = $this->ctrl->display->getText();
        $mail = $this->ctrl->mail->getText();
        $pwd = $this->ctrl->pwd->getText();
        $cpwd = $this->ctrl->cpwd->getText();
        $role = $this->ctrl->role->getDText();
        $active = ($this->ctrl->active->getText() == NULL ? "F" : "T");
        
        $error = "";
        if($user == ""){
            $error .= "<li>User Name cannot be empty!</li>";
        }
        if ($display == ""){
            $error .= "<li>Display Name cannot be empty!</li>";
        }
        if ($mail == ""){
            $error .= "<li>E-mail address cannot be empty!</li>";
        }
        if (is_numeric($role) === false){
            $error .= "<li>Invalid role selected!</li>";
        }
        if ($active == "" || $active == NULL){
            $error .= "<li>Invalid active status!</li>";
        }
        if ($error !== ""){
            echo "You have some errors:<br/><ul>$error</ul>";
            return;
        }
        
        if (strpos($mail, ".") == FALSE || strpos($mail,"@") == FALSE){
            $error .= "<li>Invalid E-mail address!</li>";
        }
        if ($pwd != "" && $pwd !== $pwd){
            $error .= "<li>Password and Confirm password must be the same!</li>";
        }
        if ($error !== ""){
            echo "You have some errors:<br/><ul>$error</ul>";
            return;
        }
        
        $data = array();
        $sSql = "";
        if ($pwd !== ""){
            $sSql = ", password=:pwd";
            $data[":pwd"] = $this->model->login->enc($pwd);
        }
        
        $sql = "update tbl_user set username=:user, display=:display, email=:mail, active=:active, role=:role $sSql where userid=:id limit 1";
        $data[":user"]  = $user;
        $data[":display"] = $display;
        $data[":mail"] = $mail;
        $data[":active"] = $active;
        $data[":role"] = $role;
        $data[":id"] = $id;
        $a = $this->db->executeUpdate($sql, $data);
        if ($a > 0) $this->model->login->log("Edit user [id=$id]");
        echo $a;
    }
}
