<?php

class postModel
{
    private $db;
    private $paging;
    private $items;
    function init(){
        $this->items = $this->model->ajax->getItemsPerPage();
        $this->db = new DATABASE(DB_HOST, DB_NAME, DB_USER, DB_PASS);
        $this->paging = new PAGING(DB_HOST, DB_NAME, DB_USER, DB_PASS, $this->items);
    }
    
    function getPostCategory(){
        $this->model->upload->getCategory($this->db, 1);
    }
    
    function getData($catId, $result, $page){
        $c = $catId;
        $resultOriginal = $result;
        $result = urldecode(urldecode($result));
        if ($c !== "") 
        {
            $c = $this->ctrl->getName($c);
            if (is_numeric($c) == false) $c = "";
        }else{
            $catId = $this->url->getSubPage("cat");
            $c = $catId;
            $c = $this->ctrl->getName($c);
            if (is_numeric($c) == false) $c = "";
        }
        
        if ($page == 0){
            $page = $this->url->getSubPage(1);
            
        }
        if (is_numeric($page) == false || $page < 1) $page = 1;
        
//        $sql = "select c.*, d.display from (
//                            select b.*, a.cat_name from(
//                            select * from tbl_category where cat_parent_id = 1 
//                            ) a inner join (
//                            select * from tbl_post where post_title like :result and cat_id like :catId
//                            ) b on a.cat_id = b.cat_id
//                            ) c inner join tbl_user d on c.post_by = d.userid order by c.post_id desc";
        $result = "%" . $result . "%";
        while(strpos($result, "%%") !== false) $result = str_replace ("%%", "%", $result);
        $sql = "select a.cat_name, b.*, c.display from tbl_category a inner join tbl_post b on a.cat_id=b.cat_id inner join tbl_user c on c.userid=b.post_by where b.cat_id like :catId and b.post_title like :result";
        $data = array(":catId"=>$c . "%", ":result"=>$result);
        $rows = $this->paging->executeQuery($sql, $data, $page, PDO::FETCH_OBJ);
        
        if (count($rows) > 0){
            foreach($rows as $row){
                $id = $row->post_id;
                $eid = $this->ctrl->$id;
                $title = $row->post_title;
                $author = $row->display;
                $urlCat = "/catalog/post.aspx/1/?cat=" . $this->ctrl->get($row->cat_id);
                $category = $row->cat_name;
                $img = $row->post_thumbnail;
                $date = $row->post_last_update;
                if ($img != "" && file_exists(_CHILE_HTDOCS_."images/post/$img")){
                    $img = _CHILD_SITE_ . "images/post/$img";
                }else{
                    $img = "";
                }
                
                $act = $row->post_active;
                if ($act == "0" || $act == 'F'){
                    $title = "Publish";
                    $ico = "open";
                }else{
                    $title = "Unpublish";
                    $ico = "close";
                }
                echo "<tr>
                                        <td>
                                            <input type='checkbox' class='chk' id='$eid'/>
                                        </td>
                                        <td>{$row->post_title}</td>
                                        <td>$author</td>
                                        <td>
                                            <a href='$urlCat'>$category</a>
                                        </td>
                                        <td>
                                            <img src='$img' class='thumb' />
                                        </td>
                                        <td>$date</td>
                                        <td>
                                                <span class='glyphicon glyphicon-pencil point' style='padding-right:10px;' data-title='Edit' title='Edit'></span>
                                                <span class='glyphicon glyphicon-trash point' data-title='Delete' style='padding-right:10px;' title='Delete'></span>
                                                <span class='glyphicon point glyphicon-eye-$ico' data-title='state' title='$title'></span>
                                        </td>
                                    </tr>";
            }
            
//            if ($this->paging->getPageCount($sql,$data) > 1){
//                if (strpos($result, "%") === 0)
//                    $result = substr($result, 1);
//                
//                $rs = urlencode(urlencode($result));
//                echo "<tr><td colspan='10' id='paging' style='text-align:right;'>" . $this->paging->getPagingControl("/catalog/post.aspx", $page, "/?cat=$catId&r=$rs") . "</td></tr>";
//            }
            $ct = $this->paging->getPagingControl("/catalog/post.aspx", $page, "/?cat=$catId&r=$resultOriginal");
            if ($ct != ""){
                echo "<tr><td colspan='10' id='paging' style='text-align:right;'>" . $ct . "</td></tr>";
            }
                echo "<script>
                                $('#paging').children('input[type=button]').each(
                                    function (){ 
                                        $(this).addClass('btn btn-default');
                                        $(this).css('margin-left', '5px');
                                    }
                                );
                                $('#txtPagingControl').addClass('textbox');
                                $('#txtPagingControl').css('width','220px');
                                $('#txtPagingControl').css('margin-left','5px');
                                
$(document).ready(function(){
                                $('span[data-title=Edit]').each(function(){
                                    $(this).click(function(){
                                        $('#blanket').css('display', 'table');
                                        var a = $(this).parent().parent();
                                        var b = '/ajax.htm/post/edit/' + a.find('input[type=checkbox]').attr('id');

                                        $.ajax({url : b}).done(function(msg){
                                            $('#blanket').css('display', 'none');
                                            if (msg === '0'){
                                                show('Error', 'You have choosen an incorrect Post!<br/>Please try again!');
                                            }else{
                                                $('#" . $this->ctrl->main . "').html(msg);
                                                $('#del').html('CANCEL');
                                                $('#" . $this->ctrl->btnAdd . "').hide(100);
                                                $('#pnFooter').hide(100);
                                                $('#btnDelete').removeClass('disabled');
                                                $('#brandName').html('Edit Post');
                                            }
                                        });
                                    });
                                });
                                    
                                    $('span[data-title=Delete]').each(function(){
                                        $(this).click(function(){
                                            $('.chkAll').prop('checked', false);
                                            $('.chk').each(function(){
                                                $(this).prop('checked', false);
                                            });
                                             var a = $(this).parent().parent();
                                             a.find('input[type=checkbox]').prop('checked', true);
                                             " . $this->ctrl->btnDelete_click . "();
                                        });
                                    });
                                    
                                    $('span[data-title=state]').each(function(){
                                        $(this).click(function(){
                                            $('#blanket').css('display', 'table');
                                            var a = $(this).parent().parent();
                                            var b = '/ajax.htm/post/state/' + a.find('input[type=checkbox]').attr('id');
                                                
                                            $.ajax({url : b}).done(function(msg){
                                                $('#blanket').css('display', 'none');
                                                
                                                    var b = null; 
                                                    $('span[data-title=state]').each(function(){
                                                        var aa = $(this).parent().parent().find('input[type=checkbox]');
                                                        if (aa.attr('id') == msg){
                                                            b = $(this);
                                                            return;
                                                        }
                                                    });
                                                    
                                                    if (b !== null){
                                                        b.tooltip('destroy');
                                                        if (b.hasClass('glyphicon-eye-open') === true){
                                                            b.removeClass('glyphicon-eye-open');
                                                            b.addClass('glyphicon-eye-close');
                                                            b.attr('title','Unpublish');
                                                        }else{
                                                            b.removeClass('glyphicon-eye-close');
                                                            b.addClass('glyphicon-eye-open');
                                                            b.attr('title','Publish');
                                                        }
                                                        b.tooltip('init');
                                                    }
                                            });
                                        });
                                    });
                                    
});
                            </script>";
        }else{
            echo "<tr><td colspan='7' class='al-center'>No Records!</td></tr>";
        }
    }
    
    function changePostState($eid){
        $id = $this->ctrl->getName($eid);
        if (is_numeric($id) == false){
            return;
        }
        
        $sql = "update tbl_post set post_active = 
                                case
                                        when post_active = '1' then '0'
                                        when post_active = '0' then '1'
                                        when post_active = 'T' then 'F'
                                        when post_active = 'F' then 'T'
                                end
                            where post_id=:id limit 1";
        $data = array(":id"=>$id);
        if ($this->db->executeUpdate($sql, $data)){
            $this->model->log->addLog("Change Post Status[ID:$id]");
            echo $eid;
        }
    }
    
    function doDeletePost(){
        $ids = explode(";", $this->ctrl->ids->getText());
        $cnt = count($ids);
        for ($i = 0; $i < $cnt; $i++){
            $a = $this->ctrl->getName($ids[$i]);
            if (is_numeric($a)){
                $this->deleteImages($a);
                $sql = "delete from tbl_post WHERE post_id=:id limit 1";
                $data = array(":id"=>$a);
                $b = $this->db->executeUpdate($sql, $data);
                if ($b > 0) $this->model->log->addLog("Delete Post[ID:$a]");
            }
        }
        echo $cnt;
    }
    
    function deleteImages($id){
        if (is_numeric($id) == false) return;
        
        $sql = "select * from tbl_post where post_id=:id limit 1";
        $data = array(":id"=>$id);
        $rows = $this->db->executeQuery($sql, $data, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            $rows = $rows[0];
            $path = _CHILE_HTDOCS_ . "images/post/";
            $img = $rows->post_image;
            $thum = $rows->post_thumbnail;
            
            if (file_exists($path.$img) && is_file($path.$img))
                unlink ($path.$img);
            if (file_exists($path.$thum) && is_file($path.$thum))
                unlink ($path.$thum);
        }
    }
    
    function doAddPost(){
        $cat = $this->ctrl->cat->getDText();
        if (is_numeric($cat) == false){
            echo "Invalid Category ID!";
            return;
        }
        
        $title = $this->ctrl->title->getText();
        if ($title == ""){
            echo "Title is require!";
            return;
        }
        
        $status = $this->ctrl->status->getDText();
        if ($status !== "T" && $status !== "F"){
            echo "Status is invalid!";
            return;
        }
        
        $shortDesc = $this->ctrl->txtText->getText();
        $content = $this->ctrl->content->getText();
        $img = $this->model->upload->uploadImage($this->ctrl->fileinput, "images/post/");
        $thum = "";
        if ($img !== NULL){
            $thum = $this->model->upload->createThumb("images/post/".$img, 300);
        }else{
            $img = "";
        }
        
        $title = strip_tags($title);
        $shortDesc = strip_tags($shortDesc);
        
        $dt = date("Y-m-d H:i:sa");
        $data = array(":title"=>$title, ":image"=>$img, ":thumbnail"=>$thum, ":summary"=>$shortDesc, ":content"=>$content,
                    ":pub"=>$status, ":category"=>$cat, ":createdate"=>$dt, ":admin"=>$this->model->login->getUserId(),
                    ":lastUpd"=>$dt);
        
        $sql = "INSERT INTO tbl_post(post_title, post_image, post_thumbnail, post_short_description, post_description, post_active, cat_id, post_date, post_by, post_last_update)
                                                    VALUES(:title, :image, :thumbnail, :summary, :content, :pub, :category, :createdate, :admin, :lastUpd);";
        
        $a = $this->db->executeUpdate($sql, $data);
        if ($a > 0) $this->model->log->addLog("Add New Post[TITLE:$title]");
        echo $a;
    }
    
    function getEditPost($eid){
        $id = $this->ctrl->getName($eid);
        if (is_numeric($id) == false){
            return NULL;
        }
        
        $sql = "select * from tbl_post where post_id=:id limit 1";
        $data = array(":id"=>$id);
        $row = $this->db->executeQuery($sql, $data, PDO::FETCH_OBJ);
        if (count($row) > 0){
            return $row[0];
        }
        return NULL;
    }
    
    function doEditPost(){
        $id = $this->ctrl->id->getDText();
        if(is_numeric($id) == false){
            echo "Invalid Post ID!";
            return;
        }
        $cat = $this->ctrl->cat->getDText();
        if (is_numeric($cat) == false){
            echo "Invalid Category ID!";
            return;
        }
        
        $title = $this->ctrl->title->getText();
        if ($title == ""){
            echo "Title is require!";
            return;
        }
        
        $status = $this->ctrl->status->getDText();
        if ($status !== "T" && $status !== "F"){
            echo "Status is invalid!";
            return;
        }
        
        $shortDesc = $this->ctrl->txtText->getText();
        $content = $this->ctrl->content->getText();
        
        $title = strip_tags($title);
        $shortDesc = strip_tags($shortDesc);
        $data = array(":title"=>$title,":summary"=>$shortDesc, ":content"=>$content,
                    ":pub"=>$status, ":category"=>$cat,
                    ":lastUpd"=>date("Y-m-d H:i:sa"), ":id"=>$id);
        
        $sSql = "";
        $img = $this->model->upload->uploadImage($this->ctrl->fileinput, "images/post/");
        if ($img !== NULL){
            $thum = $this->model->upload->createThumb("images/post/".$img, 300);
            $this->deleteImages($id);
            $data[":image"] = $img;
            $data[":thumbnail"] = $thum;
            $sSql = " post_thumbnail=:thumbnail, post_image=:image,";
        }
        
        $sql = "UPDATE tbl_post SET post_title=:title,
                                                               $sSql
                                                                post_short_description=:summary,
                                                                post_description=:content,
                                                                post_active=:pub,
                                                                post_last_update=:lastUpd,
                                                                cat_id=:category 
                                        WHERE post_id=:id limit 1;";
     
        $a = $this->db->executeUpdate($sql, $data);
        if ($a > 0) $this->model->log->addLog("Edit Post[ID:$id]");
        echo $a;
    }
    
}

?>