<?php

class ipfilterModel
{
    private $db;
    private $paging;
    function init(){
        $this->db = new DATABASE(DB_HOST, DB_NAME, DB_USER, DB_PASS);
        $this->paging = new PAGING(DB_HOST, DB_NAME, DB_USER, DB_PASS, 20);
    }
    
    function isEnabledIPfilter(){
        $sql = "select sc_ipfilter, sc_ipfilter_enable from tbl_config limit 1";
        $row = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
        $a = NULL;
        if (count($row) > 0){
            $row = $row[0];
            $a = array("status"=>$row->sc_ipfilter, "isEnable"=>$row->sc_ipfilter_enable);
        }else{
            $a = array("status"=>"0", "isEnable"=>"0");
        }
        return $a;
    }
    
    function doChangeStatus(){
        $status = $this->url->getSubPage("s");
        if ($status != "1" && $status != "0"){
            echo "0";
            return;
        }
        $sql = "update tbl_config set sc_ipfilter=:status limit 1";
        $data = array(":status"=>$status);
        $a = $this->db->executeUpdate($sql, $data);
        if ($a > 0) $this->model->login->log("Change blocking IP status");
        echo $a;
    }
    
    function doChangeEnableStatus(){
        $status = $this->ctrl->getName($this->url->getSubPage("s"));
        if ($status != "1" && $status != "0"){
            echo "0";
            return;
        }
        $sql = "update tbl_config set sc_ipfilter_enable=:status limit 1";
        $data = array(":status"=>$status);
        $a = $this->db->executeUpdate($sql, $data);
        if ($a > 0) $this->model->login->log("Change IP filter status");
        echo $a;
    }
    
    function doChangeItemsStatus(){
        $eip = $this->url->getSubPage("s");
        $ip = $this->ctrl->getName($eip);
        
        $sql = "update tbl_ipfilter set isEnabled = case when isEnabled = '0' then '1' else '0' end where ip=:ip limit 1";
        $data = array(":ip"=>$ip);
        $r = $this->db->executeUpdate($sql, $data);
        if ($r){
            $this->model->login->log("[ip filter] Change item status[ip=$ip]");
            echo $eip;
        }else "0";
    }
            
    function getIpAddress($pageNum = 1){
        if (is_numeric($pageNum) === false || $pageNum < 1) $pageNum = 1;
        
        $sql = "select * from tbl_ipfilter";
        $rows = $this->paging->executeQuery($sql, array(), $pageNum, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            foreach($rows as $row){
                $ip = $row->ip;
                $eip = $this->ctrl->get($ip);
                $label = ($row->isEnabled == "0" ? "Disable" : "Enable");
                $cls = ($row->isEnabled == "0" ? "label-default" : "label-primary");
                $status = "<span class='chgStatus label point $cls' id='$eip' title='Click me to change status'>$label</span>";
                echo "<tr>
                                    <td>{$row->ip}</td>
                                    <td>{$row->description}</td>
                                    <td>
                                        $status &nbsp;
                                        <span class='edit point glyphicon glyphicon-pencil' title='Edit' data-title='Edit'></span> &nbsp;
                                        <span class='delete point glyphicon glyphicon-trash' title='Delete' data-title='Delete'></span>
                                    </td>
                                </tr>";
            }
            
            if($this->paging->getPageCount($sql) > 1)
                echo "<tr><td colspan='6' id='paging' class='al-right'>" . $this->paging->getPagingControl("/security/ipfilter.aspx", $pageNum) . "</td></tr>";
            
             echo "<script>
                                        $('.chgStatus').click(function (){
                                                $('#blanket').css('display', 'table');
                                                var {$this->ctrl->eip} = $(this).attr('id');
                                                var {$this->ctrl->url} = '/process/ipfilter.aspx?token={$this->ctrl->itemsStatus}&s=' + {$this->ctrl->eip};

                                                $.ajax({url: {$this->ctrl->url}}).done(function (msg){
                                                    $('#blanket').css('display', 'none');
                                                    if (msg == {$this->ctrl->eip}){
                                                            {$this->ctrl->changeStatus}(msg);
                                                    }
                                                });
                                            });

                                        $('.delete').click(function(){
                                            $('#blanket').css('display', 'table');
                                            var a = $(this).parent().find('span[class*=chgStatus]').attr('id');
                                            var b = '/process/ipfilter.aspx?token=" . $this->ctrl->delete . "&s=' + a;
                                            $.ajax({url : b}).done(function(){
                                                " . $this->ctrl->fnQuery . "();
                                            });
                                        });

                                        $('.edit').click(function(){
                                            $('#blanket').css('display', 'table');
                                            var a = $(this).parent().find('span[class*=chgStatus]').attr('id');
                                            var u = '/ajax.htm/' + a + '?page=ipfilter&token=" . $this->ctrl->edit . "';
                                            $('#" . $this->ctrl->hd . "').val(a);
                                            $.ajax({url:u}).done(function(msg){
                                                if (msg !== '0'){
                                                    var b = msg.split('[dara_spliter]');
                                                    if (b.length > 1){
                                                        $('#" . $this->ctrl->ip . "').val(b[0]);
                                                        $('#" . $this->ctrl->desc . "').val(b[1]);
                                                        $('#" . $this->ctrl->estatus . "').html(b[2]);
                                                        " . $this->ctrl->changeTextStatus . "($('#" . $this->ctrl->estatus . "'));
                                                            
                                                        $('#" . $this->ctrl->save1 . "').html('Update');
                                                        $('#" . $this->ctrl->btnReset . "').html('Cancel');
                                                        $('#panel-header').html('<b>Edit IP Address</b>');
                                                    }
                                                }
                                                $('#blanket').css('display', 'none');
                                            });
                                    });

                            </script>";
        }else{
            echo "<tr><td colspan='4' class='al-center'>No Records!</td></tr>";
        }
    }
    
    function doDeleteIP(){
        $ids = $this->url->getSubPage("s");
        $a = $this->ctrl->getName($ids);
        $sql = "delete from tbl_ipfilter WHERE ip=:id limit 1";
        $data = array(":id"=>$a);
        $b = $this->db->executeUpdate($sql, $data);
        if ($b > 0) $this->model->login->log("Delete ip $a");
        echo $b;
    }
    
    function doAddIP(){
        $ip = $this->ctrl->ip->getText();
        if ($ip == "" || strlen($ip) > 15){
            echo "Invalid IP Address!";
            return;
        }
        $a = explode(".", "");
        if (count($a) > 4 && count($a) < 4){
            echo "Invalid IP address format!";
            return;
        }else{
            for($i = 0; $i < count($a); $i++){
                if ($a[$i] > 255){
                    echo "IP address must be in range 0 to 255 only!";
                    return;
                }
            }
        }
        
        $status = $this->ctrl->status->getDText();
        if ($status !== "1" && $status !== "0"){
            echo "Invalid status!";
            return;
        }
        
        $sql = "select count(*) from tbl_ipfilter where ip=:ip limit 1";
        $data = array(":ip"=>$ip);
        $desc = $this->db->executeScalare($sql, $data);
        if ($desc > 0){
            echo "IP Address is exist! Try again with new IP!";
            return;
        }
        
        $desc = $this->ctrl->desc->getText();
        
        $sql = "insert into tbl_ipfilter(ip, description, isEnabled) values(:ip, :desc, :status);";
        $data = array(":ip"=>$ip, ":desc"=>$desc, ":status"=>$status);
        $b = $this->db->executeUpdate($sql, $data);
        if ($b > 0) $this->model->login->log("[ip filter] Add  new ip $a");
        echo $b;
    }
    
    function getEditIP($eip){
        $ip = $this->ctrl->getName($eip);
        
        $sql = "select * from tbl_ipfilter where ip=:ip limit 1";
        $data = array(":ip"=>$ip);
        $row = $this->db->executeQuery($sql, $data, PDO::FETCH_OBJ);
        if (count($row) > 0){
            $row = $row[0];
            $seperator = "[dara_spliter]";
            echo $row->ip . $seperator . $row->description . $seperator . ($row->isEnabled == '1' ? "Disable" : "Enable") . $seperator . $this->ctrl->get($row->isEnabled);
            return;
        }
        echo "0";
    }
    
    function doEditIP(){
        $old = $this->ctrl->eip->getDText();
        if ($old == NULL || $old == ""){
            echo "Invalid Old IP address!";
            return;
        }
        
        $ip = $this->ctrl->ip->getText();
        if ($ip == "" || strlen($ip) > 15){
            echo "Invalid IP Address!";
            return;
        }
        $a = explode(".", "");
        if (count($a) > 4 && count($a) < 4){
            echo "Invalid IP address format!";
            return;
        }else{
            for($i = 0; $i < count($a); $i++){
                if ($a[$i] > 255){
                    echo "IP address must be in range 0 to 255 only!";
                    return;
                }
            }
        }
        if ($old != $ip){
            $sql = "select count(*) from tbl_ipfilter where ip=:ip limit 1";
            $data = array(":ip"=>$ip);
            $desc = $this->db->executeScalare($sql, $data);
            if ($desc > 0){
                echo "IP Address is exist! Try again with new IP!";
                return;
            }
        }
        
        $status = $this->ctrl->status->getDText();
        if ($status !== "1" && $status !== "0"){
            echo "Invalid status!";
            return;
        }
        
        $desc = $this->ctrl->desc->getText();
        
        $sql = "update tbl_ipfilter set ip=:ip, description=:desc, isEnabled=:status where ip=:old limit 1";
        $data = array(":ip"=>$ip, ":desc"=>$desc, ":status"=>$status, ":old"=>$old);
        $b = $this->db->executeUpdate($sql, $data);
        if ($b > 0) $this->model->login->log("[ip filter] Edit ip $ip");
        echo $b;
    }
    
    function canAccess(){
       $r = strtolower($this->model->whiteurl->getExceptionAliase());
       $url = strtolower($this->url->getFullUrl());
        if ($url != $r && $url !== "") {
            if ($this->validateIP() == false){
                return FALSE;
            }
            return $this->model->timefilter->verifyTimeLogin();
        }
        return TRUE;
    }
            
    function validateIP(){
        $sql = "select sc_ipfilter, sc_ipfilter_enable, sc_alias_exception from tbl_config limit 1";
        $r = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
        $result = $r[0];
        if ($result->sc_ipfilter == "0") return true;
        
        $ser = new SERVER();
        $ip = $ser->getIP();
        $sql = "select count(*) from tbl_ipfilter where ip=:ip and isEnabled='1' limit 1";
        $data = array(":ip"=>$ip);
        $r = $this->db->executeScalare($sql, $data);
        
        if ($result->sc_ipfilter_enable == "1"){
            if ($r > 0) return true;
            return false;
        }else{
            if ($r > 0) return false;
            return true;
        }
    }
}

?>