<?php

class resultModel
{
    private $db;
    private $paging;
    private $pg;
    function init(){
        $this->db = new DATABASE(DB_HOST, DB_NAME, DB_USER, DB_PASS);
        $this->paging = new PAGING(DB_HOST, DB_NAME, DB_USER, DB_PASS, 5);
        
        //Use with search by result
        $this->pg = new PAGING(DB_HOST, DB_NAME, DB_USER, DB_PASS, 25);
    }
    
    function searchDayName($dayName, $page = 1){
        if (is_numeric($page) === FALSE || $page < 1) $page = 1;
        
        $sql = "select dayid from tbl_day where upper(dayname) = :date limit 1";
        $data = array(":date"=>strtoupper($dayName));
        $dayid = $this->db->executeScalare($sql, $data);
        
        $sql = "select a.* from(
                                select DISTINCT(date_) from tbl_pools where dayid=:did and date_ < :now order by date_ desc
                            ) a";
        $rows = $this->paging->executeQuery($sql, array(":did"=>$dayid, ":now"=>date("Y-m-d")), $page, PDO::FETCH_OBJ);
        $result = "";
        $control = "";
        if (count($rows) > 0){
            $q = "";
            foreach($rows as $row){
                $q .= "date_ <'{$row->date_}' or ";
            }
            $q = substr($q, 0, strlen($q) - strlen(" or "));
            
            $sql = "select a.*, b.price from (
                                            select * from tbl_pools where $q 
                                   ) a inner join tbl_price b on a.priceid = b.priceid
                                    order by date_ desc, priceid asc";
            $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
            foreach ($rows as $row){
                    $result .= "<tr class='dyn td2_home1'><td>{$row->date_}</td><td class='td2_home1'>{$row->price}</td><td class='td2_home1'>{$row->description}</td><td class='td2_home1'>{$row->result}</td></tr>";
            }
            $control = $this->paging->getPagingControl("/result/$dayName.html", $page);
        }else{
            $result = "<tr><td colspan='4' class='al-center td2_home1'>No result found!</td></tr>";
        }
        
        return array("result"=>$result, "page"=>$control);
    }
    
    function searchMonth($monthName, $page = 1){
        if (is_numeric($page) === FALSE || $page < 1) $page = 1;
        
        $m = $monthName;
        $year = explode("-", $monthName);
        $monthName = (isset($year[0]) ? $year[0] : date("M"));
        $year = (isset($year[1]) ? $year[1] : date("Y"));
        
        $sql = "select monthid from tbl_month where upper(monthname) = :month limit 1";
        $data = array(":month"=>strtoupper($monthName));
        $dayid = $this->db->executeScalare($sql, $data);
        
        $sql = "select a.* from(
                                select DISTINCT(date_) from tbl_pools where monthid=:mid and year(date_) = :year and date_ < :now order by date_ desc
                            ) a";
        $rows = $this->paging->executeQuery($sql, array(":mid"=>$dayid, ":year"=>$year, ":now"=>date("Y-m-d H:i:s")), $page, PDO::FETCH_OBJ);
        $result = "";
        $control = "";
        if (count($rows) > 0){
            $q = "";
            foreach($rows as $row){
                $q .= "date_ <'{$row->date_}' or ";
            }
            $q = substr($q, 0, strlen($q) - strlen(" or "));
            
            $sql = "select a.*, b.price from (
                                            select * from tbl_pools where $q 
                                   ) a inner join tbl_price b on a.priceid = b.priceid
                                    order by date_ desc, priceid asc";
            $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
            foreach ($rows as $row){
                    $result .= "<tr class='dyn td2_home1' ><td>{$row->date_}</td><td class='td2_home1'>{$row->price}</td><td class='td2_home1'>{$row->description}</td><td class='td2_home1'>{$row->result}</td></tr>";
            }
            $control = $this->paging->getPagingControl("/result/month.html", $page, "?key=$m");
        }else{
            $result = "<tr><td colspan='4' class='al-center td2_home1'>No result found!</td></tr>";
        }
        
        return array("result"=>$result, "page"=>$control);
    }
    
    function searchByKeyword($keyword, $page = 1){
        $keyword = urldecode(urldecode($keyword));
        if (is_numeric($page) === FALSE || $page < 1) $page = 1;
        $r = '%' . $keyword . ($keyword == "" ? "" : "%");
        
        //Check if user search for result
        if (is_numeric($keyword) === TRUE) return $this->searchByResult($keyword, $page);
        
        //$data = array(":date"=>$keyword, ":result" => $r);
        $data = array(":date"=>$r, ":result" => $r, ":NOW"=>date("Y-m-d"));
        $sql = "select DISTINCT(date_) from tbl_pools where (date_ < :NOW) and (cast(date_ as char) like :date or result like :result)";
        $rows = $this->paging->executeQuery($sql, $data, $page, PDO::FETCH_OBJ);
        
        $result = "";
        $control = "";
        if (count($rows) > 0){
             $q = "";
            foreach($rows as $row){
                $q .= "date_ ='{$row->date_}' or ";
            }
            $q = substr($q, 0, strlen($q) - strlen(" or "));
            
            $sql = "select a.*, b.price from (
                                            select * from tbl_pools where $q 
                                   ) a inner join tbl_price b on a.priceid = b.priceid
                                    order by date_ desc, priceid asc";
            $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
            
            $a = "";
            foreach ($rows as $row){
                    $result .= "<tr class='dyn td2_home1'><td>{$row->date_}</td><td class='td2_home1'>{$row->price}</td><td class='td2_home1'>{$row->description}</td><td class='td2_home1'>{$row->result}</td></tr>";
            }
            
            $control = $this->paging->getPagingControl("/result/search", $page, "?key=" . urlencode(urlencode($keyword)));
        }else{
            $result = "<tr><td colspan='4' class='al-center td2_home1'>No result found!</td></tr>";
        }
        
        
        return array("result"=>$result, "page"=>$control);
    }
    
    function searchByResult($result, $page = 1){
        $r = '%' . $result . ($result == "" ? "" : "%");
        $sql = "select a.*, b.price from tbl_pools a inner join tbl_price b on a.priceid = b.priceid
                                   where result like :result and a.date_ = :now
                                    order by date_ desc, priceid asc";
        
        $rows = $this->pg->executeQuery($sql, array(":result"=>$r, ":now"=>date("Y-m-d H:i:s")), $page,PDO::FETCH_OBJ);

        $out = "";
        $control = "";
        if (count($rows) > 0){
            foreach ($rows as $row){
                    $out .= "<tr class='dyn td2_home1'><td>{$row->date_}</td><td class='td2_home1'>{$row->price}</td><td class='td2_home1'>{$row->description}</td><td class='td2_home1'>{$row->result}</td></tr>";
            }

            $control = $this->pg->getPagingControl("/result/search", $page, "?key=" . $result);
        }else{
            $out = "<tr><td colspan='4' class='al-center td2_home1'>No result found!</td></tr>";
        }
        
        return array("result"=>$out, "page"=>$control);
    }
            
    function getCurrentResultData(){
        $sql = "select a.*, b.price, b.release_hour, b.delay_mn from(
                                select * from tbl_pools where date_ = (select max(date_) from tbl_pools where date_ < :now)
                            ) a inner join tbl_price b on a.priceid = b.priceid order by priceid asc";
        //$sql = "select a.*, b.price, b.release_hour, b.delay_mn from tbl_pools a inner join tbl_price b on a.priceid = b.priceid where date_ < :now order by a.date_ desc limit 1";
        return $this->db->executeQuery($sql, array(":now"=>date("Y-m-d H:i:s")), PDO::FETCH_OBJ);
    }
    
    function getCurrentResult(){
        $re = $this->getCurrentResultData();
        $date = "";
        $result = "";
        if (count($re) > 0){
            $date = "Draw No: " . $re[0]->date_;
            foreach($re as $row){
                $a = round((strtotime(date("H:i:s")) - strtotime($row->release_hour)) / 60, 0, PHP_ROUND_HALF_DOWN );
                $a = round($a / $row->delay_mn, 0, PHP_ROUND_HALF_DOWN);
                
                $today = date("Y-m-d");
                $b = $row->result;
                if ($today == $row->date_){
                    for ($i = 0; $i < strlen($b); $i++){
                        //if ($i - 1 > $a){
                        if ($i > $a){
                            $b[$i] = "x";
                        }
                    }
                }
                
                for($i = 0; $i < 10; $i++){
                    $b = str_replace($i, "<img src='/images/result/$i.png' alt='$i'/>", $b);
                }
                
                $b = str_replace("x", "<img src='/images/result/question.png' alt='x'/>", $b);
                $result .= "<tr><td class='td1_home1'>{$row->price}</td><td class='td2_home1'>{$row->description}</td><td class='td2_home1 al-right'>{$b}</td></tr>"; 
            }
            //print_r($this->getNextDrawText($re));
        }else{
            $result = "<tr><td colspan='3' style='text-align:center;'>No result found</td></tr>";
        }
        return array("date"=>$date, "result"=>$result, "next_draw"=>"Next draw will be held on " . $this->getNextDrawText($re) . "<br/>(UTC/GMT +2)") ;
    }
    
    function getMonthForSearch(){
        $s = $this->url->getSubPage(1);
        if ($s == "month.html") $s = $this->url->getSubPage("key");
        
        $sql = "SELECT Expr1 AS month_, Expr2 AS year_, cnt FROM (
                            SELECT MONTH(date_) AS Expr1, YEAR(date_) AS Expr2 ,count(DISTINCT(date_)) as cnt
                            FROM   tbl_pools WHERE date_ < NOW()
                            GROUP BY MONTH(date_), YEAR(date_) order by date_ desc
                            ) a";
        $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
        $result = "";
        foreach($rows as $row){
            $val = $this->getMonthNameById($row->month_) . "-" . $row->year_;
            $check = ($val == $s ? "selected" : "");
            $result .= "<option value='$val' $check>$val  ({$row->cnt})</option>";
        }
        return $result;
    }
    
    function getMonthNameById($id = 1){
        if ($id > 0 && $id < 13){
            $sql = "select monthname from tbl_month where monthid = :id limit 1";
            return $this->db->executeScalare($sql, array(":id"=>$id));
        }
        return NULL;
    }
    
    function getNextDrawText($data){
        $sql = "select * from tbl_price";
        $prices = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
       
        $result = "";
        if(count($data) > 0){
            //Get Result Type and price
            $cnt = 0;
            $results[] = array();
            foreach($data as $row){
                $a = round((strtotime(date("H:i:s")) - strtotime($row->release_hour)) / 60, 0, PHP_ROUND_HALF_DOWN );
                $a = round($a / $row->delay_mn, 0, PHP_ROUND_HALF_DOWN);
                
                $today = date("Y-m-d");
                $b = trim($row->result);
                if ($today == $row->date_){
                    for ($i = 0; $i < strlen($b); $i++){
                        if ($i > $a){
                            $results[$cnt][0] = $row->release_hour;
                            $results[$cnt][1] = $row->delay_mn;
                            $results[$cnt][2] = $i + 1;
                            $cnt++;
                            break;
                        }
                    }   
                }
            }
            
            if ($cnt == 0){//Work if the result will be released on next day
                $a = str_replace(":", "", $prices[0]->release_hour);
                $hour = $prices[0]->release_hour;
                foreach($prices as $price){
                    $b = str_replace(":", "", $price->release_hour);
                    if ($a > $b){ 
                        $a = $b;
                        $hour = $price->release_hour;
                    }
                }
                $result = date("Y-m-d", strtotime(date("Y-m-d"). "+1 day")) . " " . date("H:i", strtotime('2012-02-01 '.$hour));
            }else{ //Work if the result will be released on today
                $a = str_replace(":", "", $results[0][0]);
                $hour = $results[0][0];
                foreach($results as $re){
                     $b = str_replace(":", "", $re[0]);
                    for ($i = 1; $i < $re[2]; $i++){
                            $b = date("H:i", strtotime("2012-02-01 ".$b . "+{$re[1]} minute"));
                    }
                    
                    $c = str_replace(":", "", $b);
                    if ($a > $c){
                        $a = $c;
                        $hour = $re[0];
                    }
                }
                $result = date("Y-m-d") . " $hour";
            }
        }
        $result = date("Y-m-d H:i:s", strtotime($result . " -5hours"));
        $date = explode(" ", $result);
        $hour = $date[1];
        $date = $date[0];
        $time = date("Y-m-d H:i:s");
        return "<span id='next_draw_date'>" . $date . "</span> <span id='next_draw_hour'>" . $hour . "</span>";
    }
}
