<?php
/**
 * This framework is written by LEAM LIDARA
 * Version: 1.3.9
 * 
 * Last Update: 12/22/2014 9:43am
 */

/**
 * Configuration parameters:
 * $dirMVCPath = MVC Path of your website where you store directory (Controller, Model, View) in
 *               Ex: /root/leamlidara/mvc/app
 * $dirLibPath = Library Path
 *               Ex: /root/leamlidara/library
 * $publicPath = public directory of your website where you store your entire files
 *               Ex: /root/leamlidara/website/
 * $skipUrlIndexCount = number of index of your URL that you want to skip
 *                      Ex: 0, 1, 2, 3, 4, 6, 10
 * 
 * Optional parameters:
 * $showError : (Boolean) let system show an error or save an error to a file
 * $errorFile : file (include file path) to be save error log in. I am not recommand to change it because it will be unsecure if you changed it
 * $disable_ip_verify : (Boolean) let system to disable ip verify on session
 */

if (!isset($skipUrlIndexCount)){
    $skipUrlIndexCount = 0;
}
if (!isset($showError)){
    $showError = FALSE;
}
if (!isset($errorFile)){
    $errorFile = $publicPath."errorlog";
}
if (!isset($disable_ip_verify)){
    $disable_ip_verify = FALSE;
}

    if (!isset($_SESSION)){
        @session_write_close();
        @session_start();
    }
    
    ob_start();
    
    date_default_timezone_set("Asia/Phnom_Penh");
    
    class CONFIG{
        private $website = '';
        private $library = '';

        
        public function __construct($websitePath, $libraryPath){
            $this->website = $websitePath;
            $this->library = $libraryPath;
            
            //$this->website = $this->addLastChar($this->website);
            //$this->library = $this->addLastChar($this->library);
        }
        
        public function getWebsitePath(){
            return  $this->website;
        }
        
        public function getLibraryPath(){
            return $this->library;
        }
        
        private function addLastChar($para){
            $para = str_replace("\\", "/", $para);

            $para = $para.'/';
                
            return $para;
        }
        
        private function add($param, $cmpChar){
            if (strpos($param, $cmpChar) == true){
                return $cmpChar;
            }
            return '';
        }
    }
    
    //Initialize Configuration
    $config = new CONFIG($dirMVCPath, $dirLibPath);

    //Include and Init DDOS Protection
    include_once $config->getLibraryPath().'Security/DDOS.php';
    
    include_once $config->getLibraryPath().'Security/SECURITY.php';
    
 //Include library files
    include_once $config->getLibraryPath()."Server/SERVER.php";
    include_once $config->getLibraryPath()."Session/SESSION.php";
    include_once $config->getLibraryPath().'Url/URL.php';
    include_once $config->getLibraryPath().'Controls/CONTROLS.php';
    include_once $config->getLibraryPath().'Controller/CONTROLLER.php';
    include_once $config->getLibraryPath().'View/VIEW.php';
    include_once $config->getLibraryPath().'Model/MODEL.php';
    include_once $config->getLibraryPath().'Directory/DIRECTORIES.php';
    include_once $config->getLibraryPath()."Resources/RESOURCES.php";
    include_once $config->getLibraryPath()."Database/DATABASE.php";
    include_once $config->getLibraryPath()."Download/DOWNLOAD.php";
    include_once $config->getLibraryPath()."Download/GET_FILE.php";
    include_once $config->getLibraryPath()."Upload/UPLOAD.php";
    include_once $config->getLibraryPath()."Captcha/CAPTCHA.php";
    include_once $config->getLibraryPath()."Paging/PAGING.php";
    include_once $config->getLibraryPath()."Image/IMAGE.php";
    include_once $config->getLibraryPath()."Mail/MAIL.php";
    include_once $config->getLibraryPath()."Route/ROUTE.php";
   

    $abc = new URL($skipUrlIndexCount);
    $a = $abc->getPage();
    if ($a == 'favicon.ico') exit();
    
    //Initialize Controller path
    $controllerPath = $config->getWebsitePath()."Controller/";
    
    //Initialize path
    define('MODEL_', $config->getWebsitePath().'Model/');
    define('VIEW_', $config->getWebsitePath().'View/');
    define('CONTROLLER_', $controllerPath);
    define("DISABLE_IP_FILTER", "$disable_ip_verify");
    
    //Loading Resource
    new RESOURCES($publicPath, $skipUrlIndexCount);
    
    //Loading Download File
    new GET_FILE();
 
    //Initialize Class Components
    
    /*$url = new URL();
    $ctrl = new CONTROLS();
    $dir = new DIRECTORIES($config->getWebsitePath()."public/");
    $sdir = new SDIRECTORIES($config->getWebsitePath().'app/sdir/');
    $db = new DATABASE('localhost:3168', "fast2b");
    $dl = new DOWNLOAD($config->getWebsitePath().'public/');*/
    /*$ext = array("jpg", 'png', 'bmp','php');
    $upd = new UPLOAD($config->getWebsitePath().'app/Sdir/', $ext, false);*/

    //$session->web = $config->getWebsitePath();
    //$session->lib = $config->getLibraryPath();
    $route = new ROUTE($controllerPath);
    $route->defualt("index");
    $route->error($showError);
    $route->errorFile = $errorFile;
    $route->skipUrlIndexCount = $skipUrlIndexCount;
    $route->run();
?>