<?php

include_once dirname(__DIR__).'/Database/DATABASE.php';

class PAGING{
    private $db;
    private $itemPerPage;
    private $sql;
    private $data;
    
    /**
     * Separator between page and page number
     * Ex: www.example.com/index.php?page=1
     * @var ?page= is a separator
     * @var type String
     */
    public $separator;

    public function __construct($DB_HOST, $DB_NAME, $DB_USER = 'root', $DB_PASS = '', $itemPerPage = 5)
    {
        $this->db = new DATABASE($DB_HOST, $DB_NAME, $DB_USER, $DB_PASS);
        $this->itemPerPage = $itemPerPage;
        if ($this->itemPerPage < 2) $this->itemPerPage = 5;
        $this->separator = "/";
    }
    
    /**
     * query data from your sql database
     * @param string $sql query sql to query data
     * @param type $data list of array which contents parameters and value
     * @param int $pageNumber Page number which you want to query data
     * @param type $setFetchmode fetch mode of your SQL
     * @return array data return data of your sql
     */
    public function executeQuery($sql, $data = array(), $pageNumber = 1, $setFetchmode = PDO::FETCH_ASSOC){
        
        if (is_numeric($pageNumber) == false || $pageNumber < 1) $pageNumber = 1;
        
        $offset = ($pageNumber - 1) * $this->itemPerPage;
        $this->sql = $sql;
        $this->data = $data;
        $orSql = $sql;
        if (substr(strtolower($sql), 0, 5) !== "call "){
            $sql = $sql." limit $offset, $this->itemPerPage";
        }
        $rows = $this->db->executeQuery($sql, $data, $setFetchmode);
        
        /*if (count($rows) < 1 && $pageNumber > 1){
            $pageNumber = 1;
            $offset = ($pageNumber - 1) * $this->itemPerPage;
            if (substr(strtolower($orSql), 0, 5) !== "call "){
                $sql = $orSql." limit $offset, $this->itemPerPage";
            }
            $rows = $this->db->executeQuery($sql, $data, $setFetchmode);
        }*/
        
        return $rows;
    }
    
    /**
     * Set Items per page to be query
     * @param int $itemsPerPage 
     */
    public function setItemsPerPage($itemsPerPage){
        $this->itemPerPage = $itemsPerPage;
    }

    /**
     * get number of page from your select sql statement
     * @param type $normalSql sql which you use to query data
     * @return int number of page
     */
    public function getPageCount($normalSql, $data = array()){
        if (substr(strtolower($normalSql), 0, 5) !== "call "){
            $cnt = $this->db->executeScalare("select count(*) from ($normalSql) a", $data);
        }else{
            $cnt = $this->db->executeScalare($normalSql, $data);
        }
        
        $page = 0;
        if (is_numeric($cnt)){
            if ($cnt > $this->itemPerPage){
                $page = (int)($cnt / $this->itemPerPage);
                
                if ($cnt % $this->itemPerPage > 0) $page += 1;
            }else
            {
                $page = 1;
            }
        }
        //$this->sql = $normalSql;
        //$this->data = $data;
        return $page;
    }
   
    /**
     * Get paging control
     * @param String $currentURL Current URL that you are standing on
     * @param String $currentPage Current page that you are standing on
     * @param String $postfixString string to be add to the end of your URL string
     * @param String $sqlForCountItems SQL which use to count page (Manually)
     * @param Array $data Data for this query
     * @return String control String of your Control paging
     */
    public function getPagingControl($currentURL, $currentPage, $postfixString = "", $sqlForCountItems = "", $data = array()){
        if (is_numeric($currentPage) === false || $currentPage <1) $currentPage = 1;
        if ($sqlForCountItems === ""){
            $count = $this->getPageCount($this->sql, $this->data);
        }else{
            $count = $this->getPageCount($sqlForCountItems, $data);
        }
        
        if ($currentPage > $count) $currentPage = $count;
        
        if ($count > 1){
            $p = "<script language='javascript'>function gotoUrlPaging_(e){
                    e=e||window.event;
                    var a = document.getElementById('txtPagingControl');
                    if (e.which === 13 || e.charCode === 13 || e.keyCode === 13){
                        e.preventDefault();
                        e.stopPropagation();
                        e.stopImmediatePropagation();
                        if (a.value.trim() != ''){
                            var b = a.value;
                            if (b < $count + 1)
                                gotoPage(a.value);

                        }
                        return 12;
                    }
                    return false;
                  }

                   function keyPress(e){
                        if (e.keyCode > 47 && e.keyCode < 58) return true;
                        return false;
                   }

                   function gotoPage(pageNum){
                        window.location.href = '".$currentURL."$this->separator' + pageNum + '".$postfixString."';
                   }
                  </script>";
            if ($currentPage > 1){
                $ab = 1;
                $p .= "<input type='button' name='btnPagingFirst' class='btnPagingFirst' value='First' onclick='gotoPage($ab)' />";
                $ab = $currentPage - 1;
                $p .= "<input type='button' name='btnPagingBack' class='btnPagingBack' value='Previous' onclick='gotoPage($ab)' />";
            }
            $p .= '<input type="text" value="" id="txtPagingControl" name="txtPagingControl" placeholder="'.$currentPage
                    .' OF '.$count.'" style="text-align: center;" onkeypress="return keyPress(event);" onkeyup="return gotoUrlPaging_(event);"/>';

            if ($currentPage < $count){
                $ab = $currentPage + 1;
                $p .= "<input type='button' name='btnPagingNext' class='btnPagingNext' value='Next' onclick='gotoPage($ab)' />";
                $ab = $count;
                $p .= "<input type='button' name='btnPagingLast'  class='btnPagingLast' value='Last' onclick='gotoPage($ab)' />";
            }
        }else{
            $p = "";
        }
        return $p;
    }
}

?>