<?php
include_once dirname(__DIR__).'/Url/URL.php';
include_once dirname(__DIR__).'/Session/SESSION.php';

if (!class_exists("MODEL")){
     class MODEL{
         private $websitePath;
         private $modelC;
         private $skipUrlIndexCount;
         public function __construct($modelMainPath, $skipUrlIndexCount = 0)
         {
             $this->websitePath = $modelMainPath;
             $this->skipUrlIndexCount = $skipUrlIndexCount;
         }

         public function __get($name)
         {   
            return $this->get($name);
         }
         
         public function get($name){
            $name  = trim(strtolower($name));
            
            if ($this->isStartWithNumber($name)) $name = '_'.$name;
            
            $class = $name."Model";
            if (!isset($this->modelC[$name])){
                if (file_exists($this->websitePath . $class . ".php"))
                {
                    include_once $this->websitePath . $class . ".php";
                    if (class_exists($class))
                    {
                        $this->modelC[$name] = new $class();
                        $this->modelC[$name]->model = $this;
                        
                        $this->modelC[$name]->controller = new CONTROLLER(CONTROLLER_, $this->skipUrlIndexCount);
                        $this->modelC[$name]->ctrl = new CONTROLS();
                        $this->modelC[$name]->url = new URL($this->skipUrlIndexCount);
                        $this->modelC[$name]->session = new SESSION();
                        if (method_exists($this->modelC[$name], "init"))
                        {
                            $this->modelC[$name]->init();
                        }
                    }
                    else
                    {
                        return null;
                    }
                }
                else
                {
                    return null;
                }
            }

             return $this->modelC[$name];
         }
         
        private function isStartWithNumber($str){
            $a = substr($str, 0, 1);
            $ret = false;
            switch ($a){
                case '1':
                case '2':        
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case '0':
                    $ret = true;
            }
            return $ret;
        }
     }
}
?>