<?php
    include_once dirname(__DIR__).'/Security/SECURITY.php';
if (!class_exists("DATABASE")){
    
    class DATABASE {
        private $connectionString, $db_pwd, $db_usr;
        
        public function __construct($DB_HOST, $DB_NAME, $DB_USER = 'root', $DB_PASS = '') {
            $this->connectionString = 'mysql:host=' . $DB_HOST . ';dbname=' . $DB_NAME;
            $this->db_pwd = $DB_PASS;
            $this->db_usr = $DB_USER;
            //parent::__construct('mysql:host='.$DB_HOST.';dbname='.$DB_NAME, $DB_USER, $DB_PASS);  
            //parent::setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        }
        
        /**
         * executeQuery use to get data from current database
         * @param stirng $sql An sql string
         * @param array $data parameter to bind (include parameter name and value)
         * @param constant $setFetchmode A PDO fetch mode 
         * @return mixed var return False if exist rows
         */
        public function executeQuery($sql, $data=array(), $setFetchmode=PDO::FETCH_ASSOC){
            $sth= new PDO($this->connectionString, $this->db_usr, $this->db_pwd);
            $sth->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $prepare = $sth->prepare($sql);
            if (is_array($data)){
                foreach ($data as $key=>$value){
                    if (!is_array($value)){
                        $value1 = $this->securityEnc($value);
                        $prepare->bindValue("$key",$value1);
                    }else{
                        foreach ($value as $k=>$val){
                            $val1 = $this->securityEnc($val);
                            $prepare->bindValue("$k",$val1);
                        }
                    }
                }
            }
            
            $result = $prepare->execute() or die();
            if (count($result) > 0){
                $rows = $prepare->fetchAll($setFetchmode);
                $sth = null;
                $prepare = null;
                return $rows;
            }else{
                $sth = null;
                $prepare = null;
                return false;
            }
        }
        
        private function securityEnc($str){
            //XSS Prevention 
            $ret = SECURITY::cleanXXS($str);
            
            //SSI Prevention
            $ret = str_replace("#", htmlspecialchars("#"), $ret);
            
            //Other Prevention
            $ret = str_replace("\\", htmlspecialchars("\\"), $ret);
            
            return trim($ret);
        }
        
        private function convertStringToHTML($str){
            $len = strlen($str);
            $ret = "";
            for ($i = 0; $i < $len; $i++){
  
            }
            return $ret;
        }


        public function executeScalare($sql, $data = array()){
            $result = $this->executeQuery($sql, $data, PDO::FETCH_NUM);
            if ($result !== false && count($result) > 0){
                $row = $result[count($result) - 1];
                return $row[count($row)-1];
            }else{
                return null;
            }
        }
        
        /**
         * executeUpdate use to change value in database
         * @param string $sql An sql string
         * @param array $data parameter to bind (include parameter and value)
         * @return mixed
         */
        public function executeUpdate($sql, $data=array()){
            $a= new PDO($this->connectionString, $this->db_usr, $this->db_pwd);
            $a->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $prepare = $a->prepare($sql);
            foreach ($data as $key=>$value){
                if (!is_array($value)){
                    $value1 = $this->securityEnc($value);
                    $prepare->bindValue("$key",$value1);
                }else{
                    foreach ($value as $k=>$val){
                        $val1 = $this->securityEnc($val);
                        $prepare->bindValue("$k",$val1);
                    }
                }
            }
            
            $prepare->execute();
            $b = $prepare->rowCount();
            $a = null;
            $prepare = null;
            return $b;
        }

        /**
         *
         * @param string $table
         * @param string $condition
         * @param integer $limit
         * @return integer Affected Rows
         * 
         */
        public function delete($table,$condition,$limit=1){
            return $this->exec("DELETE FROM $table WHERE $condition LIMIT $limit");

        }
    }
}
?>