<?php

class logModel
{
    private $paging;
    function init(){
        $this->paging = new PAGING(DB_HOST, DB_NAME, DB_USER, DB_PASS, 25);
    }
    
    function getLog($page = 1, $date = NULL){
        if (is_numeric($page) === FALSE || $page < 1) $page = 1;
        $sQuery = "";
        $data = array();
        if ($date == NULL || $date == ""){
            $sQuery = "";
        }else{
            $sQuery = "where date_ like :date ";
            $data[":date"] = $date . "%";
        }
        
        $sql = "select a.*, b.username from (
                                select * from tbl_log $sQuery order by logid desc
                            ) a inner join tbl_user b on a.userid = b.userid";
        $rows = $this->paging->executeQuery($sql, $data, $page, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            foreach($rows as $row){
                echo "<tr><td>{$row->description}</td><td>{$row->username}</td><td>{$row->date_}</td></tr>";
            }
            return $this->paging->getPagingControl("/log.aspx", $page, "?date=$date");
        }else{
            echo "<tr><td colspan='3' class='al-center'>No record found!</td></tr>";
        }
        return "";
    }
}

?>