<?php

class dashboardModel {
    private $paging;
    private $db;
    function init(){
        $this->paging = new PAGING(DB_HOST, DB_NAME, DB_USER, DB_PASS, 6);
        $this->db = new DATABASE(DB_HOST, DB_NAME, DB_USER, DB_PASS);
    }
    
    function getDashboard($page = 1){
        if (is_numeric($page) === FALSE || $page < 1) $page = 1;
        $sql = "select a.* from(
                                select DISTINCT(date_) from tbl_pools
                            ) a order by a.date_ desc";
        $rows = $this->paging->executeQuery($sql, array(), $page, PDO::FETCH_OBJ);
        $result = "";
        if (count($rows) > 0){
            $q = "";
            foreach($rows as $row){
//                $q .= "date_ ='" . $row->date_ . "'";
                $q .= "date_ ='{$row->date_}' or ";
            }
            $q = substr($q, 0, strlen($q) - strlen(" or "));
            $sql = "select a.*, b.price from (
                                        select * from tbl_pools where $q) a 
                                    inner join tbl_price b on a.priceid = b.priceid order by a.priceid asc";
            $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
            if (count($rows) > 0){
                $da = array();
                foreach($rows as $row){
                    $date = str_replace("-", "", (string)$row->date_);
                    if (isset($da["$date"]) == FALSE) $da["$date"] = array();
                    $da["$date"][$row->priceid] = array();
                    $da["$date"][$row->priceid][0] = $row->price;
                    $da["$date"][$row->priceid][1] = $row->description;
                    $da["$date"][$row->priceid][2] = $row->result;
                    $da["$date"][$row->priceid][3] = $row->date_;
                }
                
                $da = $this->sortArray($da);
                
                $cnt = 1;
                foreach($da as $key=>$val){
                    $isEven = ($cnt % 2 == 1 ? TRUE : FALSE);
                    $pull = ($isEven ? "left" : "right");
                    $result .= ($isEven ? "<div class='overflow'>" : "" );
                    $date = end($val);
                    $date = $date[3];
                    //$date = $date[3];
                    $result .= "<div class='panel panel-default $pull'>
                                                    <div class='panel-heading'>
                                                        <b class='pro-date point' title='Click me to edit these results'>$date</b>
                                                        <b class='label label-default pull-right point' title='Click me to edit these results'>Edit</b>
                                                    </div>
                                                    <div class='panel-body clr-height'>";
                    $result .= "<table class='table'>
                                                            <thead><tr><td>Price</td><td>Description</td><td>Result</td></tr></thead>";
                        foreach($val as $k=>$v){
                             $result .= "<tbody><tr><td>{$v[0]}</td><td>{$v[1]}</td><td>{$v[2]}</td></tr></tbody>";
                        }
                    $result .= "</table>";
                    $result .="</div>
                                                </div>";
                    $result .= ($isEven ? "" : "</div>");
                    $cnt++;
                }
                $result .= ($cnt % 2 == 1 ? "" : "</div>");
                
                $a = $this->paging->getPagingControl("/dashboard.aspx", $page);
                if ($a !== ""){
                    $result .= "<div class='pull-right al-right' style='width:50%; display:inline-flex; justify-content:flex-end; margin-bottom:10px; padding-right: 15px;'>" . $a . "</div>";
                }
            }
        }
        return $result;
    }
    
    function sortArray($array){
        $ar = array();
        $keys = array_keys($array);
        $cnt = count($keys);
        for ($i=0; $i<$cnt; $i++){
            for($k=($i+1); $k<$cnt; $k++){
                if ($keys[$k] > $keys[$i]){
                    $big = $keys[$i];
                    $keys[$i] = $keys[$k];
                    $keys[$k] = $big;
                }
            }
        }
        
        foreach($keys as $k){
            $ar[$k] = $array[$k];
        }
        
        return $ar;
    }
}

?>