<?php
include_once dirname(__DIR__).'/Url/URL.php';
include_once dirname(__DIR__).'/Session/SESSION.php';

if (!class_exists("VIEW")){
    class VIEW{

        private $websitePath;
        private $viewC;
        private $skipUrlIndexCount;

        public function __construct($viewMainPath, $skipUrlIndexCount = 0){
            $this->websitePath = $viewMainPath;
            $this->skipUrlIndexCount = $skipUrlIndexCount;
        }

        public function __get($name) {
            return $this->show($name);
        }
        
        public function show($name){
            $name  = trim($name);
            
            if ($this->isStartWithNumber($name)) $name = '_'.$name;
            
            $class = $name;//."View";

            if(isset($this->viewC[$name]) && $this->viewC[$name] !== "NOT NULL_168"){
                return $this->viewC[$name];
            }else
            {
                $ext = (strpos($class, ".php") === false ? ".php" : "");
                
                $this->viewC[$name] = $this->getPage($this->websitePath.$class.$ext, $class);
            }
            return $this->viewC[$name];
        }
        
        private function getPage($path, $class){
	    $v = null;
            if (file_exists($path)){
                $controller = new CONTROLLER(CONTROLLER_, $this->skipUrlIndexCount);
                $url = new URL($this->skipUrlIndexCount);
                $model = new MODEL(MODEL_, $this->skipUrlIndexCount);
                $ctrl = new CONTROLS();
                $session = new SESSION();
                $view = $this;
                
                include_once $path;

                if (class_exists($class)){
                    $v = new $class();
                    $v->controller = new CONTROLLER(CONTROLLER_, $this->skipUrlIndexCount);
                    $v->url = new URL($this->skipUrlIndexCount);
                    $v->model = new MODEL(MODEL_, $this->skipUrlIndexCount);
                    $v->controls = new CONTROLS();
                    $v->session = new SESSION();                    

                    if (method_exists($v, 'init')){
                        $v->init();
                    }
                }else{
                    $v = "NOT NULL_168";
                }
            }
            return $v;
        }
        
        private function isStartWithNumber($str){
            $a = substr($str, 0, 1);
            $ret = false;
            switch ($a){
                case '1':
                case '2':        
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case '0':
                    $ret = true;
            }
            return $ret;
        }
    }
}
?>