<?php

include_once dirname(__DIR__).'/Url/URL.php';
include_once dirname(__DIR__).'/Controller/CONTROLLER.php';
include_once dirname(__DIR__).'/Controls/CONTROLS.php';
include_once dirname(__DIR__).'/Session/SESSION.php';

if (!class_exists("ROUTE")){
    class ROUTE{
        private $controllerPath;
        private $p = null;
        public $showError;
        public $errorFile;
        public $skipUrlIndexCount;

        public function __construct($controllerPath){
            $this->controllerPath = $controllerPath;
            
            $this->errorFile = "../error-log";
            $this->skipUrlIndexCount = 0;
        }
        
        public function error($status){
            $this->showError = $status;
        }

        /**
         * use to set default page for your website in case other page not found.
         * @param String $pageName set default page
         */
        public function defualt($pageName){
            if (file_exists($this->controllerPath.$pageName.'Controller.php'))
                $this->p = $pageName;
        }

        /**
         * run your page
         */
        public function run(){
            $url = new URL($this->skipUrlIndexCount);
            if ($this->showError == false){
                error_reporting(E_ALL ^ E_NOTICE);
            }else{
		error_reporting(E_ALL);
		ini_set("display_errors", 1);
	    }

            $Controller = new CONTROLLER($this->controllerPath, $this->skipUrlIndexCount);
            $Controller->defaultPage = $this->p;
            
            $obj = $Controller->get(str_replace(".", "_", $url->getPage()));

            //run if page not found
            if ($obj == null) {
                if ($this->p != null) $obj = $Controller->get($this->p);
                else
                    header('location: /');
            }

            $obj->session = new SESSION();
            $obj->controller = new CONTROLLER(CONTROLLER_, $this->skipUrlIndexCount);
            $obj->view = new VIEW(VIEW_, $this->skipUrlIndexCount);
            $obj->model = new MODEL(MODEL_, $this->skipUrlIndexCount);
            $obj->url = new URL($this->skipUrlIndexCount);

            //get request method
            $method = strtoupper($_SERVER['REQUEST_METHOD']);

            //loading controller with request method
            if (method_exists($obj, $method)){
                $this->invokeMethod($obj, $method, $url);
            }else{
                //Check if Local or hosting
                $isHosting = true;
                $ser = new SERVER();
                $ser = $ser->getIP();
                if ($ser == "127.0.0.1" || $ser = "::1") $isHosting = false;
                
                if ($isHosting === true){
                    if (method_exists($obj, "GET")){
                        $this->invokeMethod($obj, "GET", $url);
                    }else{
                        echo "No method were found!";
                    }
                }else{
                    echo "No method were found!";
                }
                unset($isHosting);
                unset($ser);
            }
            
            @ob_flush();
            if ($this->showError == false){
                $error = error_get_last();
                if ($error !== null){
                    file_put_contents($this->errorFile, '['.date("Y-m-d h:i:s A")."] Error: ".$error['type']." ".$error['message']." On file: ".$error['file'].' line '.$error['line'].PHP_EOL, FILE_APPEND);
                }
            }
        }
        
        private function appendHtmlToHead($html){
            $abc = ob_get_contents();
            $result = "";
            $headPattern = "<head>";
            ob_clean();
            echo $abc;
        }
        
        private function invokeMethod($obj, $method, $url){
            $refl = new ReflectionMethod(get_class($obj), $method);
            $numParams = $refl->getNumberOfParameters();

            if ($numParams > 0)
            {
                $param = explode('/', $url->getFullUrl());
                $obj->$method($param);
            }else{
                $obj->$method();
            }
        }
    }
}

?>