<?php
include_once dirname(__DIR__).'/Session/SESSION.php';
include_once dirname(__DIR__).'/Url/URL.php';
include_once dirname(__DIR__).'/Model/MODEL.php';
include_once dirname(__DIR__).'/View/VIEW.php';

if (!class_exists("CONTROLLER")){
    class CONTROLLER{
        private $websitePath;
        private $controller;
        public $defaultPage;
        private $skipUrlIndexCount;
        
        public function __construct($controllerMainPath, $skipUrlIndexCount = 0)
        {
            $this->websitePath = $controllerMainPath;
            $this->skipUrlIndexCount = $skipUrlIndexCount;
        }
        
        /**
         * get : use to execute controller in controller dirctory on website path
         * @param string $name represent the controller name
         * @return controller syntax
         */ 
        public function get($name){
            try{
                $name  = trim(strtolower($name));
                if ($name == '')
                {
                    $name = 'index';
                }

                if ($this->isStartWithNumber($name)) $name = '_'.$name;

                $class = $name."Controller";
                if (!isset($this->controller[$name])){
                    if (file_exists($this->websitePath . $class . ".php"))
                    {
                        include_once $this->websitePath . $class . ".php";

                        if (class_exists($class))
                        {
                            $this->controller[$name] = new $class();
                            $this->controller[$name]->controller = new CONTROLLER(CONTROLLER_, $this->skipUrlIndexCount);
                            $this->controller[$name]->view = new VIEW(VIEW_, $this->skipUrlIndexCount);
                            $this->controller[$name]->model = new MODEL(MODEL_, $this->skipUrlIndexCount);
                            $this->controller[$name]->url = new URL($this->skipUrlIndexCount);
                            $this->controller[$name]->session = new SESSION();
                            $this->controller[$name]->ctrl = new CONTROLS();
                            
                            if (method_exists($this->controller[$name], 'init'))
                            {
                                $this->controller[$name]->init();
                            }

                            /*$method = strtoupper($_SERVER['REQUEST_METHOD']);

                            //loading controller with request method
                            if (method_exists($this->controller[$name], $method))
                                $this->controller[$name]->$method();
                            */
                        }
                        else
                        {
                            $this->controller[$name] = $this->getPage($this->websitePath . $this->defaultPage . ".php", $this->defaultPage.'Controller');
                        }
                    }
                    else
                    {
                        $class = $this->defaultPage.'Controller';
                        $this->controller[$name] = $this->getPage($this->websitePath . $class . ".php", $class);
                        
                        if ($this->controller[$name] == null) echo "Page Not Found!";
                    }
                }

                    return $this->controller[$name];
            }  catch (Exception $e){
                return null;
            }
        }
        
        private function getPage($path, $class){
            try{
                $c = null;
                if (file_exists($path))
                {
                    include_once $path;

                    if (class_exists($class))
                    {
                        $c = new $class();
                        $c->controller = new CONTROLLER(CONTROLLER_, $this->skipUrlIndexCount);
                        $c->view = new VIEW(VIEW_, $this->skipUrlIndexCount);
                        $c->model = new MODEL(MODEL_, $this->skipUrlIndexCount);
                        $c->url = new URL($this->skipUrlIndexCount);
                        $c->ctr = new CONTROLS();
                        $c->session = new SESSION();

                        if (method_exists($c, 'init'))
                        {
                            $c->init();
                        }
                    }
                    else
                    {
                        return null;
                    }
                }
                return $c;
            } catch (Exception $e) {
                return null;
            }
        }
        
        private function isStartWithNumber($str){
            $a = substr($str, 0, 1);
            $ret = false;
            switch ($a){
                case '1':
                case '2':        
                case '3':
                case '4':
                case '5':
                case '6':
                case '7':
                case '8':
                case '9':
                case '0':
                    $ret = true;
            }
            return $ret;
        }
        
        public function __get($name)
        {
            return $this->get($name);
        }
    }
}
?>