<div class="panel panel-default left">
    <div class="panel-heading" id="panel-header">
        <b>Add New User</b>
    </div>
    <div class="panel-body">
        <form id="<?php echo $ctrl->form1; ?>" class="form-group form-horizontal" method="POST">
            <input type="hidden" name="<?php echo $ctrl->hd; ?>" id="<?php echo $ctrl->hd; ?>"/>
            <div class="row form-group">
                <label class="control-label col-sm-3" for="<?php echo $ctrl->user; ?>">User Name <span class="require">*</span></label>
                <div class="col-sm-9">
                    <input type="text" class="form-control" name="<?php echo $ctrl->user; ?>" id="<?php echo $ctrl->user; ?>"/>
                </div>
            </div>
            <div class="row form-group">
                <label class="control-label col-sm-3" for="<?php echo $ctrl->display; ?>">Display Name <span class="require">*</span></label>
                <div class="col-sm-9">
                    <input type="text" class="form-control" name="<?php echo $ctrl->display; ?>" id="<?php echo $ctrl->display; ?>"/>
                </div>
            </div>
            <div class="row form-group">
                <label class="control-label col-sm-3" for="<?php echo $ctrl->mail; ?>">E-mail <span class="require">*</span></label>
                <div class="col-sm-9">
                    <input type="text" class="form-control" name="<?php echo $ctrl->mail; ?>" id="<?php echo $ctrl->mail; ?>"/>
                </div>
            </div>
            <div class="row form-group">
                <label class="control-label col-sm-3" for="<?php echo $ctrl->pwd; ?>">Password <span class="require">*</span></label>
                <div class="col-sm-9">
                    <input type="password" class="form-control" name="<?php echo $ctrl->pwd; ?>" id="<?php echo $ctrl->pwd; ?>"/>
                </div>
            </div>
            <div class="row form-group">
                <label class="control-label col-sm-3" for="<?php echo $ctrl->cpwd; ?>">Confirm Password <span class="require">*</span></label>
                <div class="col-sm-9">
                    <input type="password" class="form-control" name="<?php echo $ctrl->cpwd; ?>" id="<?php echo $ctrl->cpwd; ?>"/>
                </div>
            </div>
            <div class="row form-group">
                <label class="control-label col-sm-3" for="<?php echo $ctrl->cpwd; ?>">Permission <span class="require">*</span></label>
                <div class="col-sm-9">
                    <select class="form-control" name="<?php echo $ctrl->role ?>" id="<?php echo $ctrl->role ?>">
                        <option value="<?php echo $ctrl->get("1"); ?>">Administrator</option>
                        <option value="<?php echo $ctrl->get("2"); ?>">User</option>
                    </select>
                </div>
            </div>
            <div class="row form-group">
                <span class="col-sm-3"></span>
                <label class="col-sm-9">
                    <input type="checkbox" name="<?php echo $ctrl->active; ?>" id="<?php echo $ctrl->active; ?>" checked="checked"/> Active
                </label>
            </div>
            <div class="row form-group">
                    <div class="col-sm-3"></div>
                    <div class="col-sm-9">
                        <div class="pull-right">
                            <span class="require">*</span> required field
                        </div><br/>
                        <input type="button" value="Save" class="btn btn-default" id="<?php echo $ctrl->btnOk; ?>" />
                        <input type="button" value="Reset" class="btn btn-default" id="<?php echo $ctrl->btnReset; ?>" />
                    </div>
                </div>
        </form>
    </div>
</div>
<div class="panel panel-default right">
    <div class="panel-heading">
        <b>All Users</b>
    </div>
    <div class="panel-body">
        <table class="table">
            <thead>
                <tr>
                    <th>User Name</th>
                    <th>Display Name</th>
                    <th>E-mail</th>
                    <th>Active</th>
                    <th class="col-xs-1">Action</th>
                </tr>
            </thead>
            <tbody id="<?php echo $ctrl->main; ?>">
                <?php $model->user->getUsers($url->getSubPage(1)); ?>
            </tbody>
        </table>
    </div>
</div>
<script>
    $(document).ready(function (){
        
        $("#<?php echo $ctrl->user; ?>").select();
        var <?php echo $ctrl->action; ?> = "";
        $("#<?php echo $ctrl->btnReset; ?>").click(reset);
        
        $("#<?php echo $ctrl->btnOk; ?>").click(function (){
            $("#blanket").css("display", "table");
            clearTooltip();
            
            var a = $("#<?php echo $ctrl->user; ?>");
            var b = $("#<?php echo $ctrl->display; ?>");
            var c = $("#<?php echo $ctrl->mail; ?>");
            var d = $("#<?php echo $ctrl->pwd; ?>");
            var e = $("#<?php echo $ctrl->cpwd; ?>");
            var f = $("#<?php echo $ctrl->role; ?>");
            var g = false;
            
            if(a.val().trim() === ""){
                a.attr("title", "This field cannot be empty!");
                a.tooltip("show");
                g = true;
            }
            if(b.val().trim() === ""){
                b.attr("title", "This field cannot be empty!");
                b.tooltip("show");
                g = true;
            }
            if(c.val().trim() === ""){
                c.attr("title", "This field cannot be empty!");
                c.tooltip("show");
                g = true;
            }
            if(d.val().trim() === "" && $(this).val() === "Save"){
                d.attr("title", "This field cannot be empty!");
                d.tooltip("show");
                g = true;
            }
            if(e.val().trim() === "" && $(this).val() === "Save"){
                e.attr("title", "This field cannot be empty!");
                e.tooltip("show");
                g = true;
            }
            if(f.val().trim() === ""){
                f.attr("title", "This field cannot be empty!");
                f.tooltip("show");
                g = true;
            }
            
            if (g === true){ 
                $("#blanket").css("display", "none");
                return;
            }else{
                if ($(this).val() === "Save"){
                    if (d.val() !== e.val()){
                        e.attr("title", "Password and Confirm password must be the same!");
                        e.tooltip("show");
                        g = true;
                    }
                }else{
                    if (d.val() !== ""){
                        if (d.val() !== e.val()){
                            e.attr("title", "Password and Confirm password must be the same!");
                            e.tooltip("show");
                            g = true;
                        }
                    }
                }
                if (c.val().indexOf(".") === -1 || c.val().indexOf("@") === -1){
                    c.attr("title", "Invalid E-mail address!");
                    c.tooltip("show");
                    g = true;
                }
                if (g === true){
                    $("#blanket").css("display", "none");
                    return;
                }
            }
            
            var h = "/process/user.aspx?token=<?php echo $ctrl->add; ?>";
            if ($(this).val() !== "Save") var h = "/process/user.aspx?token=<?php echo $ctrl->edit; ?>";
            $("#<?php echo $ctrl->form1; ?>").attr("action", h);
            $("#<?php echo $ctrl->form1; ?>").submit();
        });
        
        $("#<?php echo $ctrl->form1; ?>").submit(function (){
            $(this).ajaxSubmit({
                success : function (msg){
                    if (msg === "1"){
                        <?php echo $ctrl->fnQuery; ?>();
                    }else{
                        if (msg === "0"){
                            msg = "There were some problem while we are trying to process your request!";
                        }
                        
                        $('#myModalLabel').html("Error");
                        $("#modelbody").html(msg);
                        $("#btnmclose").html("Close");
                        $("#btnmok").hide();
                        $("#myModal").modal({show: true});
                        
                        $("#blanket").css("display", "none");
                    }
                }
            });
            return false;
        });
        
        function <?php echo $ctrl->fnQuery; ?>(){
            $("#blanket").css("display", "table");
            reset();
            
            $.ajax({
                url: "/ajax.htm?page=user&token=<?php echo $ctrl->get; ?>&t=<?php echo $url->getSubPage(1); ?>"
            }).done(function (msg){
                $("#<?php echo $ctrl->main; ?>").html(msg);
                
                $('#myModalLabel').html("Success");
                $("#modelbody").html("Process Completed!");
                $("#btnmclose").html("Close");
                $("#btnmok").hide();
                $("#myModal").modal({show: true});
                
                $("#blanket").css("display", "none");
            });
        }
        
        function reset(){
            clearTooltip();
            
            $("#<?php echo $ctrl->form1; ?>").attr("action", "");
            $("#<?php echo $ctrl->form1; ?>")[0].reset();
            $("#panel-header").html("<b>Add New User</b>");
            $("#<?php echo $ctrl->user; ?>").select();
            $("#<?php echo $ctrl->btnOk; ?>").val("Save");
            $("#<?php echo $ctrl->btnReset; ?>").val("Reset");
            $("#<?php echo $ctrl->pwd ?>").attr("placeholder", "");
            $("#<?php echo $ctrl->cpwd ?>").attr("placeholder", "");
        }
        
        function clearTooltip(){
            var a = $("#<?php echo $ctrl->user; ?>");
            var b = $("#<?php echo $ctrl->display; ?>");
            var c = $("#<?php echo $ctrl->mail; ?>");
            var d = $("#<?php echo $ctrl->pwd; ?>");
            var e = $("#<?php echo $ctrl->cpwd; ?>");
            var f = $("#<?php echo $ctrl->role; ?>");
            
            a.attr("title", "");
            a.tooltip("destroy");
            b.attr("title", "");
            b.tooltip("destroy");
            c.attr("title", "");
            c.tooltip("destroy");
            d.attr("title", "");
            d.tooltip("destroy");
            e.attr("title", "");
            e.tooltip("destroy");
            f.attr("title", "");
            f.tooltip("destroy");
        }
        
    });
</script>