<?php

class priceModel
{
    private $db;
    private $paging;
            
    function init(){
        $this->db = new DATABASE(DB_HOST, DB_NAME, DB_USER, DB_PASS);
        $this->paging = new PAGING(DB_HOST, DB_NAME, DB_USER, DB_PASS, 20);
    }
    
    function doAddPrice(){
        $name = $this->ctrl->name->getText();
        $delay_mn = $this->ctrl->delay_mn->getText();
        $release_hour = $this->ctrl->release_hour->getText();
        if ($name == ""){
            echo "Price name cannot be empty!";
            return;
        }
        if ($release_hour == ""){
            echo "Release hour cannot be empty!";
            return;
        }
        if (is_numeric($delay_mn) == false || strlen($delay_mn) > 4){
            echo "Delay minute is invalid!";
            return;
        }
        $desc = $this->ctrl->desc->getText();
        $sql = "select count(*) from tbl_price where price=:price limit 1";
        $r = $this->db->executeScalare($sql, array(":price"=>$name));
        if ($r == 0){
            $sql = "insert into tbl_price (price, description, release_hour, delay_mn) values(:name, :desc, :rh, :delay)";
            $data = array(":name"=>$name, ":desc"=>$desc, ":rh"=>$release_hour, ":delay"=>$delay_mn);
            $a = $this->db->executeUpdate($sql, $data);
            if ($a > 0) $this->model->login->log("Add new price [" . $name . "]");
            echo $a;
            return;
        }
        echo "Price name is already taken, please try a new one!";
    }
    
    function getPrice($pageNumber = 1){
        $page = $pageNumber;
        if (is_numeric($page) === FALSE || $page < 1) $page = 1;
        
        $sql = "select * from tbl_price";
        $rows = $this->paging->executeQuery($sql, array(), $page, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            foreach ($rows as $row){
                $act = "<span class='edit glyphicon glyphicon-pencil point' title='Edit'></span>";
                $eid = $this->ctrl->get($row->priceid);
                echo "<tr id='$eid'><td>{$row->price}</td><td>{$row->description}</td><td>{$row->release_hour}</td><td>{$row->delay_mn}</td><td class='al-center'>$act</td></tr>";
            }
            $ctr = $this->paging->getPagingControl("/addPrice.aspx", $page);
            if ($ctr !== "")
                echo "<tr><td colspan='5' class='al-right form-inline'>" . $ctr . "</td></tr>";
            echo "<script>
                $('.edit').click(function(){
                    $('#blanket').css('display', 'table');
                    var a = $(this).parent().parent().attr('id');
                    var u = '/ajax.htm/' + a + '?page=addprice&token=" . $this->ctrl->edit . "';
                    $('#" . $this->ctrl->hd . "').val(a);
                    $.ajax({url:u}).done(function(msg){
                        clearTooltip();
                        if (msg !== '0'){
                            var b = msg.split('[dara_spliter]');
                            if (b.length > 1){
                                $('#" . $this->ctrl->name . "').val(b[0]);
                                $('#" . $this->ctrl->desc . "').val(b[1]);
                                $('#" . $this->ctrl->release_hour . "').val(b[2]);
                                $('#" . $this->ctrl->delay_mn . "').val(b[3]);
                                    
                                $('#" . $this->ctrl->btnOk . "').val('Update');
                                $('#" . $this->ctrl->btnReset . "').val('Cancel');
                                $('#process-header').html('<b>Edit Price</b>');
                            }
                        }
                        $('#blanket').css('display', 'none');
                    });
                });
            </script>";
        }else{
            echo "<tr><td colspan='3' class='al-center'>No records found!</td></tr>";
        }
    }
    
    function getPriceForPools(){
        $sql = "select * from tbl_price";
        $rows = $this->db->executeQuery($sql, array(), PDO::FETCH_OBJ);
        if (count($rows) > 0){
            $a = "";
            foreach ($rows as $row){
                $eid = $this->ctrl->get($row->priceid);
                $a .= "<option value='$eid'>{$row->price}</option>";
            }
            return $a;
        }
        return "";
    }
            
    function getEditPrice($priceId){
        if (is_numeric($priceId) == FALSE){
            $priceId = $this->ctrl->getName($priceId);
        }
        if (is_numeric($priceId) == FALSE){
            echo "0";
            return;
        }
        
        $sql = "select * from tbl_price where priceid=:id limit 1";
        $data = array(":id"=>$priceId);
        $rows = $this->db->executeQuery($sql, $data, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            $rows = $rows[0];
            $seperator = "[dara_spliter]";
            echo $rows->price . $seperator . $rows->description . $seperator . $rows->release_hour . $seperator . $rows->delay_mn;
        }else{
            echo "0";
        }
    }
    
    function doEditPrice(){
        $id = $this->ctrl->hd->getDText();
        if (is_numeric($id) === FALSE){
            echo "Invalid Price ID!";
            return;
        }
        
        $name = $this->ctrl->name->getText();
        $delay_mn = $this->ctrl->delay_mn->getText();
        $release_hour = $this->ctrl->release_hour->getText();
        if ($name == ""){
            echo "Price name cannot be empty!";
            return;
        }
        if ($release_hour == ""){
            echo "Release hour cannot be empty!";
            return;
        }
        if (is_numeric($delay_mn) == false || strlen($delay_mn) > 4){
            echo "Delay minute is invalid!";
            return;
        }
        
        $desc = $this->ctrl->desc->getText();
        $sql = "update tbl_price set price=:name, description=:desc, release_hour=:rh, delay_mn=:delay where priceid=:id limit 1";
        $data = array(":name"=>$name, ":desc"=>$desc, ":rh"=>$release_hour, ":delay"=>$delay_mn, ":id"=>$id);
        $a = $this->db->executeUpdate($sql, $data);
        if ($a > 0) $this->model->login->log("Edit price $id");
        echo $a;
    }
}

?>