<?php

class poolsModel {
    private $db;
            
    function init(){
        $this->db = new DATABASE(DB_HOST, DB_NAME, DB_USER, DB_PASS);
    }
    
    function doAddPools(){
        $date = $this->ctrl->date->getText();
        $result = $this->ctrl->result->getText();
        
        if ($result == ""){
            echo "Result cannot be empty!";
            return;
        }
        
        $desc = $this->ctrl->desc->getText();
        $price = $this->ctrl->price->getDText();
        
        if ($price == "" || $price == NULL){
            echo "Please select a price!";
            return;
        }
        
        $a = DateTime::createFromFormat("Y-m-d", $date);
        $date_name = $a->format("l");
        $month_name = $a->format("F");
        $sql = "select dayid from tbl_day where lower(dayname)=lower(:name) limit 1";
        $date_name = $this->db->executeScalare($sql, array(":name"=>$date_name));
        
        $sql = "select monthid from tbl_month where lower(monthname)=lower(:name) limit 1";
        $month_name = $this->db->executeScalare($sql, array(":name"=>$month_name));
        $today = date("Y-m-d H:i:s");
        
        $sql = "select count(*) from tbl_pools where date_=:date and priceid=:price limit 1";        
        $r = $this->db->executeScalare($sql, array(":date"=>$date, ":price"=>$price));
        if ($r == 1){
            echo "Cannot have the same price on the same day, please check again!";
            return;
        }
        
        $sql = "insert into tbl_pools(result, description, dayid, monthid, priceid, userid, date_, insdate) values(:result, :desc, :day, :month, :price, :usr, :date, :insdate)";
        $data = array(":result"=>$result, ":day"=>$date_name, ":month"=>$month_name, ":price"=>$price, ":usr"=>$this->model->login->getUserId(), 
                      ":date"=>$date, ":insdate"=>$today, ":desc"=>$desc);
        $a = $this->db->executeUpdate($sql, $data);
        if ($a > 0) $this->model->login->log("Add new pools [result=$result, price=$price]");
        echo $a;
        //$start = (date('D') != 'Mon') ? date('Y-m-d', strtotime('last Monday')) : date('Y-m-d');
       //$finish = (date('D') != 'Sat') ? date('Y-m-d', strtotime('next Saturday')) : date('Y-m-d');
    }
    
    function getPoolsOfDate($date){
        $sql = "select a.*, b.price from
                                (select * from tbl_pools where date_=:date) a
                            inner join tbl_price b on a.priceid = b.priceid order by b.price";
        $data = array(":date"=>$date);
        $rows = $this->db->executeQuery($sql, $data, PDO::FETCH_OBJ);
        if (count($rows) > 0){
            foreach($rows as $row){
                $act = "<span class='edit glyphicon glyphicon-pencil point' title='Edit' style='padding-right: 20%;'></span><span class='delete glyphicon glyphicon-trash point' title='Delete'></span>";
                $prim = $this->ctrl->get($row->insdate . "|" . $row->date_ . "|" . $row->result . "|" . $row->priceid);
                echo "<tr id='$prim'><td>{$row->result}</td><td>{$row->description}</td><td>{$row->price}</td><td class='al-center'>$act</td></tr>".PHP_EOL;
            }
            echo "<script>
                $('.edit').click(function(){
                    $('#blanket').css('display', 'table');
                    var a = $(this).parent().parent().attr('id');
                    var u = '/ajax.htm/' + a + '?page=addpools&token=" . $this->ctrl->edit . "';
                    $('#" . $this->ctrl->hd . "').val(a);
                    $.ajax({url:u}).done(function(msg){
                        if (msg !== '0'){
                            var b = msg.split('[dara_spliter]');
                            if (b.length > 1){
                                $('#" . $this->ctrl->result . "').val(b[0]);
                                $('#" . $this->ctrl->desc . "').val(b[1]);
                                $('#" . $this->ctrl->price . "').val(b[2]);
                                    
                                $('#" . $this->ctrl->btnOk . "').val('Update');
                                $('#" . $this->ctrl->btnReset . "').val('Cancel');
                                $('#panel-header').html('<b>Edit Pools</b>');
                            }
                        }
                        $('#blanket').css('display', 'none');
                    });
                });
                
                $('.delete').click(function(){
                    $('#myModalLabel').html('Confirmation');
                    $('#modelbody').html('Are you sure you want to delete this item?');
                    $('#btnmclose').html('No');
                    $('#btnmok').show();
                    $('#btnmok').html('Yes');
                    var a = $(this).parent().parent().attr('id');
                    $('#" . $this->ctrl->hd . "').val(a);
                    $('#myModal').modal({show: true});
                });
            </script>";
        }else{
            echo "<tr><td colspan='3' class='al-center'>No pools on this day!</td></tr>";
        }
    }
    
    function getEditPools($poolsEid){
        $eid = explode("|", $this->ctrl->getName($poolsEid));
        if (count($eid) === 4){
            $sql = "select * from tbl_pools where insdate=:ins and date_=:date and result=:result and priceid=:priceid limit 1";
            $data = array(":ins"=>$eid[0], ":date"=>$eid[1], ":result"=>$eid[2], ":priceid"=>$eid[3]);
            $rows = $this->db->executeQuery($sql, $data, PDO::FETCH_OBJ);
            if(count($rows) > 0){
                $rows = $rows[0];
                $spliter = "[dara_spliter]";
                echo $rows->result . $spliter . $rows->description . $spliter . $this->ctrl->get($rows->priceid);
                return;
            }
        }
        echo "0";
    }
    
    function doEditPools(){
         $eid = explode("|", $this->ctrl->hd->getDText());
        if (count($eid) === 4){
            $date = $this->ctrl->date->getText();
            $result = $this->ctrl->result->getText();

            if ($result == ""){
                echo "Result cannot be empty!";
                return;
            }

            $desc = $this->ctrl->desc->getText();
            $price = $this->ctrl->price->getDText();

            if ($price == "" || $price == NULL){
                echo "Please select a price!";
                return;
            }

            $a = DateTime::createFromFormat("Y-m-d", $date);
            $date_name = $a->format("l");
            $month_name = $a->format("F");
            $sql = "select dayid from tbl_day where lower(dayname)=lower(:name) limit 1";
            $date_name = $this->db->executeScalare($sql, array(":name"=>$date_name));

            $sql = "select monthid from tbl_month where lower(monthname)=lower(:name) limit 1";
            $month_name = $this->db->executeScalare($sql, array(":name"=>$month_name));
            $today = date("Y-m-d H:i:s");

            //$data = array(":ins"=>$eid[0], ":date"=>$eid[1], ":result"=>$eid[2], ":priceid"=>$eid[3]);
            //$sql = "insert into tbl_pools(result, description, dayid, monthid, priceid, userid, date_, insdate) values(:result, :desc, :day, :month, :price, :usr, :date, :insdate)";
            $sql = "update tbl_pools set result=:result, description=:desc, dayid=:day, monthid=:month, priceid=:price, userid=:usr, date_=:date, insdate=:insdate 
                                    where insdate=:orins and date_=:ordate and result=:orresult and priceid=:orpriceid limit 1";
            
            $data = array(":result"=>$result, ":day"=>$date_name, ":month"=>$month_name, ":price"=>$price, ":usr"=>$this->model->login->getUserId(), 
                          ":date"=>$date, ":insdate"=>$today, ":desc"=>$desc, ":orins"=>$eid[0], ":ordate"=>$eid[1], ":orresult"=>$eid[2], ":orpriceid"=>$eid[3]);
            $a = $this->db->executeUpdate($sql, $data);
            if ($a > 0) $this->model->login->log("Update pools [result=$result, price=$price]");
            echo $a;
            return;
        }
        echo "0";
    }
    
    function doDeletePools($poolsEid){
        $eid = explode("|", $this->ctrl->getName($poolsEid));
        if (count($eid) === 4){
            $sql = "delete from tbl_pools where insdate=:ins and date_=:date and result=:result and priceid=:priceid limit 1";
            $data = array(":ins"=>$eid[0], ":date"=>$eid[1], ":result"=>$eid[2], ":priceid"=>$eid[3]);
            $a = $this->db->executeUpdate($sql, $data, PDO::FETCH_OBJ);
            if ($a > 0) $this->model->login->log("Delete pools [result={$eid[2]}, price={$eid[3]}, result date={$eid[1]}]");
            echo $a;
            return;
        }
        echo "0";
    }
}

?>